/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet42RemoveMobEffect;
import net.minecraft.server.Packet60Explosion;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishAnnounceManipulator;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.event.VanishStatusChangeEvent;
import org.kitteh.vanish.metrics.MetricsOverlord;

public class VanishManager {
    private final VanishPlugin plugin;
    private final Set<String> vanishedPlayerNames;
    private final Map<String, Boolean> sleepIgnored;
    private final VanishAnnounceManipulator announceManipulator;
    private final Random random = new Random();
    private final ShowPlayerHandler showPlayer;

    public VanishManager(VanishPlugin plugin) {
        this.plugin = plugin;
        this.announceManipulator = new VanishAnnounceManipulator(this.plugin);
        this.vanishedPlayerNames = Collections.synchronizedSet(new HashSet());
        this.sleepIgnored = new HashMap<String, Boolean>();
        this.showPlayer = new ShowPlayerHandler();
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this.showPlayer, 4L, 4L);
    }

    public VanishAnnounceManipulator getAnnounceManipulator() {
        return this.announceManipulator;
    }

    public VanishPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isVanished(Player player) {
        return this.vanishedPlayerNames.contains(player.getName());
    }

    public boolean isVanished(String playerName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player != null) {
            Debuggle.log("Testing vanished status of " + player.getName() + ": " + this.isVanished(player));
            return this.isVanished(player);
        }
        Debuggle.log("Testing vanished status of " + playerName + ": null");
        return false;
    }

    public int numVanished() {
        return this.vanishedPlayerNames.size();
    }

    public void onPluginDisable() {
        this.revealAll();
    }

    public void playerQuit(Player player) {
        Debuggle.log("Quitting: " + player.getName());
        this.resetSleepingIgnored(player);
        VanishPerms.userQuit(player);
        this.removeVanished(player.getName());
    }

    public void playerRefresh(Player player) {
        this.resetSeeing(player);
        if (this.isVanished(player) && !VanishPerms.canVanish(player)) {
            this.toggleVanish(player);
        }
    }

    public void resetSeeing(Player player) {
        Debuggle.log("Resetting visibility on " + player.getName());
        if (VanishPerms.canSeeAll(player)) {
            this.showVanished(player);
            Debuggle.log("Showing all to " + player.getName());
        } else {
            this.hideVanished(player);
            Debuggle.log("Hiding all to " + player.getName());
        }
    }

    public void resetSleepingIgnored(Player player) {
        if (this.sleepIgnored.containsKey(player.getName())) {
            player.setSleepingIgnored(this.sleepIgnored.remove(player.getName()).booleanValue());
        }
    }

    public void setSleepingIgnored(Player player) {
        if (!this.sleepIgnored.containsKey(player.getName())) {
            this.sleepIgnored.put(player.getName(), player.isSleepingIgnored());
        }
        player.setSleepingIgnored(true);
    }

    public void toggleVanish(Player togglingPlayer) {
        String messageBit;
        this.toggleVanishQuiet(togglingPlayer);
        String vanishingPlayerName = togglingPlayer.getName();
        String base = ChatColor.YELLOW + vanishingPlayerName + " has ";
        if (this.isVanished(togglingPlayer)) {
            Debuggle.log("LoudVanishToggle Vanishing " + togglingPlayer.getName());
            this.plugin.hooksVanish(togglingPlayer);
            messageBit = "vanished. Poof.";
        } else {
            Debuggle.log("LoudVanishToggle Revealing " + togglingPlayer.getName());
            this.plugin.hooksUnvanish(togglingPlayer);
            messageBit = "become visible.";
            this.announceManipulator.vanishToggled(togglingPlayer);
        }
        String message = base + messageBit;
        togglingPlayer.sendMessage(ChatColor.DARK_AQUA + "You have " + messageBit);
        this.plugin.messageStatusUpdate(message, togglingPlayer);
    }

    public void toggleVanishQuiet(Player vanishingPlayer) {
        this.toggleVanishQuiet(vanishingPlayer, true);
    }

    public void toggleVanishQuiet(Player vanishingPlayer, boolean effects) {
        Player[] playerList;
        boolean vanishing = !this.isVanished(vanishingPlayer);
        String vanishingPlayerName = vanishingPlayer.getName();
        CraftPlayer cplr = (CraftPlayer)vanishingPlayer;
        if (vanishing) {
            Debuggle.log("It's invisible time! " + vanishingPlayer.getName());
            this.setSleepingIgnored(vanishingPlayer);
            if (VanishPerms.canNotFollow(vanishingPlayer)) {
                for (Entity entity : vanishingPlayer.getNearbyEntities(100.0, 100.0, 100.0)) {
                    Creature creature;
                    if (entity == null || !(entity instanceof Creature) || (creature = (Creature)entity) == null || creature.getTarget() == null || !creature.getTarget().equals(vanishingPlayer)) continue;
                    creature.setTarget(null);
                }
            }
            this.vanishedPlayerNames.add(vanishingPlayerName);
            cplr.getHandle().netServerHandler.sendPacket((Packet)new Packet41MobEffect(cplr.getEntityId(), new MobEffect(MobEffectList.INVISIBILITY.getId(), 0, 0)));
            MetricsOverlord.vanish.increment();
            this.plugin.log(vanishingPlayerName + " disappeared.");
        } else {
            Debuggle.log("It's visible time! " + vanishingPlayer.getName());
            this.resetSleepingIgnored(vanishingPlayer);
            this.removeVanished(vanishingPlayerName);
            cplr.getHandle().netServerHandler.sendPacket((Packet)new Packet42RemoveMobEffect(cplr.getEntityId(), new MobEffect(MobEffectList.INVISIBILITY.getId(), 0, 0)));
            MetricsOverlord.unvanish.increment();
            this.plugin.log(vanishingPlayerName + " reappeared.");
        }
        if (effects) {
            if (VanishPerms.canSmoke(vanishingPlayer)) {
                this.smokeScreenEffect(vanishingPlayer.getLocation());
            }
            if (VanishPerms.canExplode(vanishingPlayer)) {
                this.explosionEffect(vanishingPlayer);
            }
            if (VanishPerms.canLightning(vanishingPlayer)) {
                this.lightningBarrage(vanishingPlayer.getLocation());
            }
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new VanishStatusChangeEvent(vanishingPlayer, vanishing));
        for (Player otherPlayer : playerList = this.plugin.getServer().getOnlinePlayers()) {
            if (vanishingPlayer.equals(otherPlayer)) continue;
            Debuggle.log("Determining what to do about " + vanishingPlayer.getName() + " for " + otherPlayer.getName());
            if (vanishing) {
                if (!VanishPerms.canSeeAll(otherPlayer)) {
                    if (!otherPlayer.canSee(vanishingPlayer)) continue;
                    Debuggle.log("Hiding " + vanishingPlayer.getName() + " from " + otherPlayer.getName());
                    otherPlayer.hidePlayer(vanishingPlayer);
                    continue;
                }
                otherPlayer.hidePlayer(vanishingPlayer);
                this.showPlayer.add(new ShowPlayerEntry(otherPlayer, vanishingPlayer));
                continue;
            }
            if (VanishPerms.canSeeAll(otherPlayer)) {
                otherPlayer.hidePlayer(vanishingPlayer);
            }
            if (otherPlayer.canSee(vanishingPlayer)) continue;
            Debuggle.log("Showing " + vanishingPlayer.getName() + " to " + otherPlayer.getName());
            this.showPlayer.add(new ShowPlayerEntry(otherPlayer, vanishingPlayer));
        }
    }

    private void explosionEffect(Player player) {
        Location loc = player.getLocation();
        Packet60Explosion boom = new Packet60Explosion(loc.getX(), loc.getY(), loc.getZ(), 3.0f, new ArrayList(), null);
        for (Player plr : this.plugin.getServer().getOnlinePlayers()) {
            if (!plr.getLocation().getWorld().equals(loc.getWorld()) || !(plr.getLocation().distance(loc) < 256.0)) continue;
            ((CraftPlayer)plr).getHandle().netServerHandler.sendPacket((Packet)boom);
        }
    }

    private void hideVanished(Player player) {
        for (Player otherPlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (player.equals(otherPlayer) || !this.isVanished(otherPlayer) || !player.canSee(otherPlayer)) continue;
            player.hidePlayer(otherPlayer);
        }
    }

    private void lightningBarrage(Location location) {
        int x = location.getBlockX();
        double y = location.getBlockY();
        int z = location.getBlockZ();
        for (int i = 0; i < Settings.getLightningCount(); ++i) {
            double xToStrike = this.random.nextBoolean() ? (double)(x + this.random.nextInt(6)) : (double)(x - this.random.nextInt(6));
            double zToStrike = this.random.nextBoolean() ? (double)(z + this.random.nextInt(6)) : (double)(z - this.random.nextInt(6));
            Location toStrike = new Location(location.getWorld(), xToStrike, y, zToStrike);
            location.getWorld().strikeLightningEffect(toStrike);
        }
    }

    private void removeVanished(String name) {
        this.vanishedPlayerNames.remove(name);
    }

    private void revealAll() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            for (Player player2 : this.plugin.getServer().getOnlinePlayers()) {
                if (player == null || player2 == null || player.equals(player2)) continue;
                if (this.isVanished(player2) && player.canSee(player2)) {
                    player.hidePlayer(player2);
                }
                this.showPlayer.add(new ShowPlayerEntry(player, player2));
            }
        }
    }

    private void showVanished(Player player) {
        for (Player otherPlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (!this.isVanished(otherPlayer) || player.canSee(otherPlayer)) continue;
            this.showPlayer.add(new ShowPlayerEntry(player, otherPlayer));
        }
    }

    private void smokeScreenEffect(Location location) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().playEffect(location, Effect.SMOKE, this.random.nextInt(9));
        }
    }

    private class ShowPlayerHandler
    implements Runnable {
        HashSet<ShowPlayerEntry> entries = new HashSet();
        HashSet<ShowPlayerEntry> next = new HashSet();

        private ShowPlayerHandler() {
        }

        public void add(ShowPlayerEntry player) {
            this.entries.add(player);
        }

        public void run() {
            for (ShowPlayerEntry entry : this.next) {
                Player player = entry.getPlayer();
                Player target = entry.getTarget();
                if (player == null || !player.isOnline() || target == null || !target.isOnline()) continue;
                player.showPlayer(target);
            }
            this.next.clear();
            this.next.addAll(this.entries);
            this.entries.clear();
        }
    }

    private class ShowPlayerEntry {
        private final Player player;
        private final Player target;

        public ShowPlayerEntry(Player player, Player target) {
            this.player = player;
            this.target = target;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Player getTarget() {
            return this.target;
        }
    }
}

