/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import net.minecraft.server.MobEffect;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet42RemoveMobEffect;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishCheck;
import org.kitteh.vanish.VanishCommand;
import org.kitteh.vanish.VanishManager;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.hooks.HookManager;
import org.kitteh.vanish.listeners.ListenEntity;
import org.kitteh.vanish.listeners.ListenInventory;
import org.kitteh.vanish.listeners.ListenPlayerJoin;
import org.kitteh.vanish.listeners.ListenPlayerMessages;
import org.kitteh.vanish.listeners.ListenPlayerOther;
import org.kitteh.vanish.listeners.ListenToYourHeart;
import org.kitteh.vanish.listeners.TagAPIListener;
import org.kitteh.vanish.metrics.MetricsOverlord;
import org.kitteh.vanish.staticaccess.VanishNoPacket;

public class VanishPlugin
extends JavaPlugin {
    private final HashSet<String> haveInventoriesOpen = new HashSet();
    private String latestVersion = null;
    private boolean versionDiff = false;
    private VanishManager manager;
    private HookManager hookManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeClose(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chestFakeInUse(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            return this.haveInventoriesOpen.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeOpen(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.add(name);
        }
    }

    public String getCurrentVersion() {
        return "3.12.1";
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public String getLatestKnownVersion() {
        return this.latestVersion;
    }

    public VanishManager getManager() {
        return this.manager;
    }

    public void hooksJoin(Player player) {
        this.hookManager.onJoin(player);
    }

    public void hooksQuit(Player player) {
        this.hookManager.onQuit(player);
        this.hookManager.onUnvanish(player);
    }

    public void hooksUnvanish(Player player) {
        this.hookManager.onUnvanish(player);
    }

    public void hooksVanish(Player player) {
        this.hookManager.onVanish(player);
    }

    public void log(String message) {
        this.getLogger().info(message);
    }

    public void messageStatusUpdate(String message) {
        this.messageStatusUpdate(message, null);
    }

    public void messageStatusUpdate(String message, Player avoid) {
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || player.equals(avoid) || !VanishPerms.canSeeStatusUpdates(player)) continue;
            player.sendMessage(message);
        }
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || !this.manager.isVanished(player)) continue;
            ((CraftPlayer)player).getHandle().netServerHandler.sendPacket((Packet)new Packet42RemoveMobEffect(((CraftPlayer)player).getEntityId(), new MobEffect(MobEffectList.INVISIBILITY.getId(), 0, 0)));
            player.sendMessage(ChatColor.DARK_AQUA + "[Vanish] You have been forced visible by a reload.");
        }
        VanishNoPacket.setInstance(null);
        this.hookManager.onDisable();
        this.manager.onPluginDisable();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        Debuggle.nah();
        this.log("v3.12.1 unloaded.");
    }

    public void onEnable() {
        VanishNoPacket.setInstance(this);
        File check = new File(this.getDataFolder(), "config.yml");
        boolean firstTimeStarting = false;
        if (!check.exists()) {
            firstTimeStarting = true;
            Settings.deployDefaultConfig("config.yml");
            this.reloadConfig();
        }
        Settings.freshStart(this);
        MetricsOverlord.init(this);
        if (this.getConfig().getBoolean("colornametags", true)) {
            if (this.getServer().getPluginManager().isPluginEnabled("TagAPI")) {
                this.getServer().getPluginManager().registerEvents((Listener)new TagAPIListener(this), (Plugin)this);
                this.getLogger().info("Using color changing features of TagAPI.");
            } else {
                this.getLogger().info("Colored nametags enabled, but I couldn't find TagAPI");
                this.getLogger().info("For awesome colored nametags on vanish, visit");
                this.getLogger().info("http://dev.bukkit.org/server-mods/tag/ ");
                this.getLogger().info("and download TagAPI.jar");
            }
        }
        this.hookManager = new HookManager(this);
        if (this.getConfig().getBoolean("hooks.essentials", false)) {
            this.hookManager.getHook(HookManager.HookType.Essentials).onEnable();
        }
        this.hookManager.getHook(HookManager.HookType.GeoIPTools).onEnable();
        if (this.getConfig().getBoolean("hooks.dynmap", false)) {
            this.hookManager.getHook(HookManager.HookType.Dynmap).onEnable();
        }
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                if (VanishPlugin.this.getConfig().getBoolean("hooks.JSONAPI", false)) {
                    VanishPlugin.this.hookManager.getHook(HookManager.HookType.JSONAPI).onEnable();
                }
            }
        }, 1L);
        if (this.getConfig().getBoolean("hooks.spoutcraft", false)) {
            this.hookManager.getHook(HookManager.HookType.SpoutCraft).onEnable();
        }
        this.manager = new VanishManager(this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.setMetadata("vanished", (MetadataValue)new LazyMetadataValue((Plugin)this, LazyMetadataValue.CacheStrategy.NEVER_CACHE, (Callable)new VanishCheck(player.getName())));
        }
        boolean updateCheck = this.getConfig().getBoolean("checkupdates", true);
        if (firstTimeStarting) {
            updateCheck = false;
            this.log("This is your first startup (or you wiped your config).");
            this.log("In future startups, VanishNoPacket will check for updates");
            this.log("If you dislike it, disable 'checkupdates' in the config file");
            this.log("Note that this plugin also utilizes PluginMetrics with usage tracking");
            this.log("If you do not want usage tracking (paranoid) disable in that config");
        }
        if (updateCheck) {
            if ("3.12.1".contains("SNAPSHOT") || "3.12.1".equals("${project.version}")) {
                this.log("Not a release version. Update check disabled");
            } else {
                this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new UpdateCheck(this), 40L, 432000L);
            }
        }
        this.getCommand("vanish").setExecutor((CommandExecutor)new VanishCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ListenEntity(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerMessages(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerJoin(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerOther(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenToYourHeart(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenInventory(this), (Plugin)this);
        this.log("v3.12.1 loaded.");
    }

    public void reload() {
        this.reloadConfig();
        Settings.freshStart(this);
    }

    public boolean versionDifference() {
        return this.versionDiff;
    }

    private class UpdateCheck
    implements Runnable {
        private static final String address = "http://updates.kitteh.org/VanishNoPacket/version.php";
        private VanishPlugin plugin;

        public UpdateCheck(VanishPlugin vanishPlugin2) {
            this.plugin = vanishPlugin2;
        }

        public void run() {
            try {
                URL url = new URL(address.replace(" ", "%20"));
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(8000);
                connection.setReadTimeout(15000);
                connection.setRequestProperty("User-agent", "VanishNoPacket 3.12.1");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String version = bufferedReader.readLine();
                if (version != null) {
                    this.plugin.latestVersion = version;
                    if (!"3.12.1".equals(version)) {
                        this.plugin.log("Found a different version available: " + version);
                        this.plugin.log("Check http://dev.bukkit.org/server-mods/vanish/");
                        this.plugin.versionDiff = true;
                    }
                    bufferedReader.close();
                    connection.getInputStream().close();
                    return;
                }
                bufferedReader.close();
                connection.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plugin.log("Error: Could not check if plugin was up to date. Will try later");
        }
    }
}

