/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.hooks;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.Hook;

public class DynmapHook
extends Hook {
    private DynmapAPI dynmap;
    private boolean enabled = false;

    public DynmapHook(VanishPlugin plugin) {
        super(plugin);
    }

    public void onDisable() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (player == null || !this.plugin.getManager().isVanished(player)) continue;
            this.onUnvanish(player);
        }
    }

    public void onEnable() {
        this.enabled = true;
        Plugin grab = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
        if (grab != null) {
            this.dynmap = (DynmapAPI)grab;
            this.plugin.log("Now hooking into Dynmap");
        } else {
            this.plugin.log("You wanted Dynmap support. I could not find Dynmap.");
            this.dynmap = null;
            this.enabled = false;
        }
    }

    public void onJoin(Player player) {
        if (player.hasPermission("vanish.hooks.dynmap.alwayshidden")) {
            this.onVanish(player);
        }
    }

    public void onUnvanish(Player player) {
        if (this.enabled && this.dynmap != null && !player.hasPermission("vanish.hooks.dynmap.alwayshidden")) {
            this.dynmap.setPlayerVisiblity(player, true);
        }
    }

    public void onVanish(Player player) {
        if (this.enabled && this.dynmap != null) {
            this.dynmap.setPlayerVisiblity(player, false);
        }
    }
}

