/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.hooks;

import com.earth2me.essentials.IEssentials;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.Hook;

public class EssentialsHook
extends Hook {
    private final VanishPlugin plugin;
    private IEssentials essentials;
    private boolean enabled = false;

    public EssentialsHook(VanishPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void onDisable() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (player == null || !this.plugin.getManager().isVanished(player)) continue;
            this.onUnvanish(player);
        }
        this.essentials = null;
    }

    public void onEnable() {
        this.enabled = true;
        Plugin grab = this.plugin.getServer().getPluginManager().getPlugin("Essentials");
        if (grab != null) {
            this.essentials = (IEssentials)grab;
            this.plugin.log("Now hooking into Essentials");
        } else {
            this.plugin.log("You wanted Essentials support. I could not find Essentials.");
            this.essentials = null;
            this.enabled = false;
        }
    }

    public void onUnvanish(Player player) {
        if (player.hasPermission("vanish.hooks.essentials.hide")) {
            this.setHidden(player, false);
        }
    }

    public void onVanish(Player player) {
        if (player.hasPermission("vanish.hooks.essentials.hide")) {
            this.setHidden(player, true);
        }
    }

    private void setHidden(Player player, boolean hide) {
        if (this.enabled && this.essentials != null) {
            this.essentials.getUser((Object)player).setHidden(hide);
        }
    }
}

