/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.staticaccess;

import org.bukkit.entity.Player;
import org.kitteh.vanish.VanishManager;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.staticaccess.VanishNotLoadedException;

public class VanishNoPacket {
    private static VanishPlugin instance;

    public static boolean canSee(Player looking, Player uncertain) throws VanishNotLoadedException {
        VanishNoPacket.check();
        return !instance.getManager().isVanished(uncertain) || VanishPerms.canSeeAll(looking);
    }

    public static VanishManager getManager() throws VanishNotLoadedException {
        VanishNoPacket.check();
        return instance.getManager();
    }

    public static VanishPlugin getPlugin() throws VanishNotLoadedException {
        VanishNoPacket.check();
        return instance;
    }

    public static boolean isVanished(String name) throws VanishNotLoadedException {
        VanishNoPacket.check();
        return instance.getManager().isVanished(name);
    }

    public static int numVanished() throws VanishNotLoadedException {
        VanishNoPacket.check();
        return instance.getManager().numVanished();
    }

    public static void setInstance(VanishPlugin instance) {
        VanishNoPacket.instance = instance;
    }

    public static void toggleVanishSilent(Player player) throws VanishNotLoadedException {
        VanishNoPacket.check();
        instance.getManager().toggleVanishQuiet(player);
    }

    public static void toggleVanishWithAnnounce(Player player) throws VanishNotLoadedException {
        VanishNoPacket.check();
        instance.getManager().toggleVanish(player);
    }

    private static void check() throws VanishNotLoadedException {
        if (instance == null) {
            throw new VanishNotLoadedException();
        }
    }
}

