/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.util.MaterialName;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.bukkit.Location;

public class BlockChange
implements LookupCacheElement {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
    public final long id;
    public final long date;
    public final Location loc;
    public final String playerName;
    public final int replaced;
    public final int type;
    public final byte data;
    public final String signtext;
    public final ChestAccess ca;

    public BlockChange(long date, Location loc, String playerName, int replaced, int type, byte data, String signtext, ChestAccess ca) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.playerName = playerName;
        this.replaced = replaced;
        this.type = type;
        this.data = data;
        this.signtext = signtext;
        this.ca = ca;
    }

    public BlockChange(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? (long)rs.getInt("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.replaced = p.needType ? rs.getInt("replaced") : 0;
        this.type = p.needType ? rs.getInt("type") : 0;
        this.data = p.needData ? rs.getByte("data") : (byte)0;
        this.signtext = p.needSignText ? rs.getString("signtext") : null;
        this.ca = p.needChestAccess && rs.getShort("itemtype") != 0 && rs.getShort("itemamount") != 0 ? new ChestAccess(rs.getShort("itemtype"), rs.getShort("itemamount"), rs.getByte("itemdata")) : null;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.date > 0L) {
            msg.append(formatter.format(this.date)).append(" ");
        }
        if (this.playerName != null) {
            msg.append(this.playerName).append(" ");
        }
        if (this.signtext != null) {
            String action;
            String string = action = this.type == 0 ? "destroyed " : "created ";
            if (!this.signtext.contains("\u0000")) {
                msg.append(action).append(this.signtext);
            } else {
                msg.append(action).append(MaterialName.materialName(this.type != 0 ? this.type : this.replaced)).append(" [").append(this.signtext.replace("\u0000", "] [")).append("]");
            }
        } else if (this.type == this.replaced) {
            if (this.type == 0) {
                msg.append("did an unspecified action");
            } else if (this.ca != null) {
                if (this.ca.itemType == 0 || this.ca.itemAmount == 0) {
                    msg.append("looked inside ").append(MaterialName.materialName(this.type));
                } else if (this.ca.itemAmount < 0) {
                    msg.append("took ").append(-this.ca.itemAmount).append("x ").append(MaterialName.materialName(this.ca.itemType, this.ca.itemData));
                } else {
                    msg.append("put in ").append(this.ca.itemAmount).append("x ").append(MaterialName.materialName(this.ca.itemType, this.ca.itemData));
                }
            } else if (this.type == 23 || this.type == 54 || this.type == 61 || this.type == 62) {
                msg.append("opened ").append(MaterialName.materialName(this.type));
            } else if (this.type == 64 || this.type == 71 || this.type == 96 || this.type == 107) {
                msg.append(this.data == 0 ? "opened" : "closed").append(" ").append(MaterialName.materialName(this.type));
            } else if (this.type == 69) {
                msg.append("switched ").append(MaterialName.materialName(this.type));
            } else if (this.type == 77) {
                msg.append("pressed ").append(MaterialName.materialName(this.type));
            } else if (this.type == 92) {
                msg.append("ate a piece of ").append(MaterialName.materialName(this.type));
            } else if (this.type == 25 || this.type == 93 || this.type == 94) {
                msg.append("changed ").append(MaterialName.materialName(this.type));
            }
        } else if (this.type == 0) {
            msg.append("destroyed ").append(MaterialName.materialName(this.replaced, this.data));
        } else if (this.replaced == 0) {
            msg.append("created ").append(MaterialName.materialName(this.type, this.data));
        } else {
            msg.append("replaced ").append(MaterialName.materialName(this.replaced, (byte)0)).append(" with ").append(MaterialName.materialName(this.type, this.data));
        }
        if (this.loc != null) {
            msg.append(" at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ());
        }
        return msg.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

