/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChatMessage;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class Consumer
extends TimerTask {
    private final Queue<Row> queue = new LinkedBlockingQueue<Row>();
    private final Set<String> failedPlayers = new HashSet<String>();
    private final LogBlock logblock;
    private final Map<String, Integer> playerIds = new HashMap<String, Integer>();
    private final Lock lock = new ReentrantLock();

    Consumer(LogBlock logblock) {
        this.logblock = logblock;
        try {
            Class.forName("PlayerLeaveRow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void queueBlock(String playerName, Location loc, int typeBefore, int typeAfter, byte data) {
        this.queueBlock(playerName, loc, typeBefore, typeAfter, data, null, null);
    }

    public void queueBlockBreak(String playerName, BlockState before) {
        this.queueBlockBreak(playerName, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData());
    }

    public void queueBlockBreak(String playerName, Location loc, int typeBefore, byte dataBefore) {
        this.queueBlock(playerName, loc, typeBefore, 0, dataBefore);
    }

    public void queueBlockPlace(String playerName, BlockState after) {
        this.queueBlockPlace(playerName, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), after.getTypeId(), after.getRawData());
    }

    public void queueBlockPlace(String playerName, Location loc, int type, byte data) {
        this.queueBlock(playerName, loc, 0, type, data);
    }

    public void queueBlockReplace(String playerName, BlockState before, BlockState after) {
        this.queueBlockReplace(playerName, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData(), after.getTypeId(), after.getRawData());
    }

    public void queueBlockReplace(String playerName, BlockState before, int typeAfter, byte dataAfter) {
        this.queueBlockReplace(playerName, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData(), typeAfter, dataAfter);
    }

    public void queueBlockReplace(String playerName, int typeBefore, byte dataBefore, BlockState after) {
        this.queueBlockReplace(playerName, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), typeBefore, dataBefore, after.getTypeId(), after.getRawData());
    }

    public void queueBlockReplace(String playerName, Location loc, int typeBefore, byte dataBefore, int typeAfter, byte dataAfter) {
        if (dataBefore == 0 && typeBefore != typeAfter) {
            this.queueBlock(playerName, loc, typeBefore, typeAfter, dataAfter);
        } else {
            this.queueBlockBreak(playerName, loc, typeBefore, dataBefore);
            this.queueBlockPlace(playerName, loc, typeAfter, dataAfter);
        }
    }

    public void queueChestAccess(String playerName, BlockState container, short itemType, short itemAmount, byte itemData) {
        if (!(container instanceof InventoryHolder)) {
            return;
        }
        this.queueChestAccess(playerName, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getTypeId(), itemType, itemAmount, itemData);
    }

    public void queueChestAccess(String playerName, Location loc, int type, short itemType, short itemAmount, byte itemData) {
        this.queueBlock(playerName, loc, type, type, (byte)0, null, new ChestAccess(itemType, itemAmount, itemData));
    }

    public void queueContainerBreak(String playerName, BlockState container) {
        if (!(container instanceof InventoryHolder)) {
            return;
        }
        this.queueContainerBreak(playerName, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getTypeId(), container.getRawData(), ((InventoryHolder)container).getInventory());
    }

    public void queueContainerBreak(String playerName, Location loc, int type, byte data, Inventory inv) {
        ItemStack[] items;
        for (ItemStack item : items = BukkitUtils.compressInventory(inv.getContents())) {
            this.queueChestAccess(playerName, loc, type, (short)item.getTypeId(), (short)(item.getAmount() * -1), BukkitUtils.rawData(item));
        }
        this.queueBlockBreak(playerName, loc, type, data);
    }

    public void queueKill(Entity killer, Entity victim) {
        if (killer == null || victim == null) {
            return;
        }
        int weapon = 0;
        if (killer instanceof Player && ((Player)killer).getItemInHand() != null) {
            weapon = ((Player)killer).getItemInHand().getTypeId();
        }
        this.queueKill(victim.getLocation(), BukkitUtils.entityName(killer), BukkitUtils.entityName(victim), weapon);
    }

    @Deprecated
    public void queueKill(World world, String killerName, String victimName, int weapon) {
        this.queueKill(new Location(world, 0.0, 0.0, 0.0), killerName, victimName, weapon);
    }

    public void queueKill(Location location, String killerName, String victimName, int weapon) {
        if (victimName == null || !Config.isLogged(location.getWorld())) {
            return;
        }
        this.queue.add(new KillRow(location, killerName == null ? null : killerName.replaceAll("[^a-zA-Z0-9_]", ""), victimName.replaceAll("[^a-zA-Z0-9_]", ""), weapon));
    }

    public void queueSignBreak(String playerName, Location loc, int type, byte data, String[] lines) {
        if (type != 63 && type != 68 || lines == null || lines.length != 4) {
            return;
        }
        this.queueBlock(playerName, loc, type, 0, data, lines[0] + "\u0000" + lines[1] + "\u0000" + lines[2] + "\u0000" + lines[3], null);
    }

    public void queueSignBreak(String playerName, Sign sign) {
        this.queueSignBreak(playerName, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueSignPlace(String playerName, Location loc, int type, byte data, String[] lines) {
        if (type != 63 && type != 68 || lines == null || lines.length != 4) {
            return;
        }
        this.queueBlock(playerName, loc, 0, type, data, lines[0] + "\u0000" + lines[1] + "\u0000" + lines[2] + "\u0000" + lines[3], null);
    }

    public void queueSignPlace(String playerName, Sign sign) {
        this.queueSignPlace(playerName, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueChat(String player, String message) {
        for (String ignored : Config.ignoredChat) {
            if (!message.startsWith(ignored)) continue;
            return;
        }
        this.queue.add(new ChatRow(player, message.replace("\\", "\\\\").replace("'", "\\'")));
    }

    public void queueJoin(Player player) {
        this.queue.add(new PlayerJoinRow(player));
    }

    public void queueLeave(Player player) {
        this.queue.add(new PlayerLeaveRow(player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.queue.isEmpty() || !this.lock.tryLock()) {
            return;
        }
        Connection conn = this.logblock.getConnection();
        Statement state = null;
        if (this.getQueueSize() > 1000) {
            Bukkit.getLogger().info("[LogBlock Consumer] Queue overloaded. Size: " + this.getQueueSize());
        }
        try {
            if (conn == null) {
                return;
            }
            conn.setAutoCommit(false);
            state = conn.createStatement();
            long start = System.currentTimeMillis();
            int count = 0;
            block16: while (!(this.queue.isEmpty() || System.currentTimeMillis() - start >= (long)Config.timePerRun && count >= Config.forceToProcessAtLeast)) {
                Row r = this.queue.poll();
                if (r == null) continue;
                for (String player : r.getPlayers()) {
                    if (this.playerIds.containsKey(player) || this.addPlayer(state, player)) continue;
                    if (this.failedPlayers.contains(player)) continue block16;
                    this.failedPlayers.add(player);
                    Bukkit.getLogger().warning("[LogBlock Consumer] Failed to add player " + player);
                    continue block16;
                }
                for (String insert : r.getInserts()) {
                    try {
                        state.execute(insert);
                    }
                    catch (SQLException ex) {
                        Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Consumer] SQL exception on " + insert + ": ", ex);
                        break block16;
                    }
                }
                ++count;
            }
            conn.commit();
        }
        catch (SQLException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Consumer] SQL exception", ex);
        }
        finally {
            try {
                if (state != null) {
                    state.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Consumer] SQL exception on close", ex);
            }
            this.lock.unlock();
        }
    }

    public void writeToFile() throws FileNotFoundException {
        long time = System.currentTimeMillis();
        HashSet<String> insertedPlayers = new HashSet<String>();
        int counter = 0;
        new File("plugins/LogBlock/import/").mkdirs();
        PrintWriter writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-0.sql"));
        while (!this.queue.isEmpty()) {
            Row r = this.queue.poll();
            if (r == null) continue;
            for (String player : r.getPlayers()) {
                if (this.playerIds.containsKey(player) || insertedPlayers.contains(player)) continue;
                writer.println("INSERT IGNORE INTO `lb-players` (playername) VALUES ('" + player + "');");
                insertedPlayers.add(player);
            }
            for (String insert : r.getInserts()) {
                writer.println(insert);
            }
            if (++counter % 1000 != 0) continue;
            writer.close();
            writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-" + counter / 1000 + ".sql"));
        }
        writer.close();
    }

    int getQueueSize() {
        return this.queue.size();
    }

    static boolean hide(Player player) {
        String playerName = player.getName();
        if (Config.hiddenPlayers.contains(playerName)) {
            Config.hiddenPlayers.remove(playerName);
            return false;
        }
        Config.hiddenPlayers.add(playerName);
        return true;
    }

    private boolean addPlayer(Statement state, String playerName) throws SQLException {
        state.execute("INSERT IGNORE INTO `lb-players` (playername) VALUES ('" + playerName + "')");
        ResultSet rs = state.executeQuery("SELECT playerid FROM `lb-players` WHERE playername = '" + playerName + "'");
        if (rs.next()) {
            this.playerIds.put(playerName, rs.getInt(1));
        }
        rs.close();
        return this.playerIds.containsKey(playerName);
    }

    private void queueBlock(String playerName, Location loc, int typeBefore, int typeAfter, byte data, String signtext, ChestAccess ca) {
        if (playerName == null || loc == null || typeBefore < 0 || typeAfter < 0 || typeBefore > 255 || typeAfter > 255 || Config.hiddenPlayers.contains(playerName) || !Config.isLogged(loc.getWorld()) || typeBefore != typeAfter && Config.hiddenBlocks.contains(typeBefore) && Config.hiddenBlocks.contains(typeAfter)) {
            return;
        }
        this.queue.add(new BlockRow(loc, playerName.replaceAll("[^a-zA-Z0-9_]", ""), typeBefore, typeAfter, data, signtext != null ? signtext.replace("\\", "\\\\").replace("'", "\\'") : null, ca));
    }

    private String playerID(String playerName) {
        if (playerName == null) {
            return "NULL";
        }
        Integer id = this.playerIds.get(playerName);
        if (id != null) {
            return id.toString();
        }
        return "(SELECT playerid FROM `lb-players` WHERE playername = '" + playerName + "')";
    }

    private class PlayerLeaveRow
    implements Row {
        private final String playerName;
        private final long leaveTime;

        PlayerLeaveRow(Player player) {
            this.playerName = player.getName();
            this.leaveTime = System.currentTimeMillis() / 1000L;
        }

        @Override
        public String[] getInserts() {
            return new String[]{"UPDATE `lb-players` SET onlinetime = onlinetime + TIMESTAMPDIFF(SECOND, lastlogin, FROM_UNIXTIME('" + this.leaveTime + "')) WHERE lastlogin > 0 && " + (Consumer.this.playerIds.containsKey(this.playerName) ? "playerid = " + Consumer.this.playerIds.get(this.playerName) : "playerName = '" + this.playerName + "'") + ";"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class PlayerJoinRow
    implements Row {
        private final String playerName;
        private final long lastLogin;
        private final String ip;

        PlayerJoinRow(Player player) {
            this.playerName = player.getName();
            this.lastLogin = System.currentTimeMillis() / 1000L;
            this.ip = player.getAddress().toString().replace("'", "\\'");
        }

        @Override
        public String[] getInserts() {
            return new String[]{"UPDATE `lb-players` SET lastlogin = FROM_UNIXTIME(" + this.lastLogin + "), firstlogin = IF(firstlogin = 0, FROM_UNIXTIME(" + this.lastLogin + "), firstlogin), ip = '" + this.ip + "' WHERE " + (Consumer.this.playerIds.containsKey(this.playerName) ? "playerid = " + Consumer.this.playerIds.get(this.playerName) : "playerName = '" + this.playerName + "'") + ";"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class ChatRow
    extends ChatMessage
    implements Row {
        ChatRow(String player, String message) {
            super(player, message);
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.playerName) + ", '" + this.message + "');"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class KillRow
    implements Row {
        final long date = System.currentTimeMillis() / 1000L;
        final String killer;
        final String victim;
        final int weapon;
        final Location loc;

        KillRow(Location loc, String attacker, String defender, int weapon) {
            this.loc = loc;
            this.killer = attacker;
            this.victim = defender;
            this.weapon = weapon;
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `" + Config.getWorldConfig((World)this.loc.getWorld()).table + "-kills` (date, killer, victim, weapon, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.killer) + ", " + Consumer.this.playerID(this.victim) + ", " + this.weapon + ", " + this.loc.getBlockX() + ", " + this.loc.getBlockY() + ", " + this.loc.getBlockZ() + ");"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.killer, this.victim};
        }
    }

    private class BlockRow
    extends BlockChange
    implements Row {
        public BlockRow(Location loc, String playerName, int replaced, int type, byte data, String signtext, ChestAccess ca) {
            super(System.currentTimeMillis() / 1000L, loc, playerName, replaced, type, data, signtext, ca);
        }

        @Override
        public String[] getInserts() {
            String table = Config.getWorldConfig((World)this.loc.getWorld()).table;
            String[] inserts = new String[this.ca != null || this.signtext != null ? 2 : 1];
            inserts[0] = "INSERT INTO `" + table + "` (date, playerid, replaced, type, data, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.playerName) + ", " + this.replaced + ", " + this.type + ", " + this.data + ", '" + this.loc.getBlockX() + "', " + this.loc.getBlockY() + ", '" + this.loc.getBlockZ() + "');";
            if (this.signtext != null) {
                inserts[1] = "INSERT INTO `" + table + "-sign` (id, signtext) values (LAST_INSERT_ID(), '" + this.signtext + "');";
            } else if (this.ca != null) {
                inserts[1] = "INSERT INTO `" + table + "-chest` (id, itemtype, itemamount, itemdata) values (LAST_INSERT_ID(), " + this.ca.itemType + ", " + this.ca.itemAmount + ", " + this.ca.itemData + ");";
            }
            return inserts;
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private static interface Row {
        public String[] getInserts();

        public String[] getPlayers();
    }
}

