/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.Block;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.MaterialName;
import de.diddiz.util.Utils;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldEditQueryParams
extends QueryParams {
    public Selection sel = null;

    public WorldEditQueryParams(LogBlock logblock) {
        super(logblock);
    }

    public WorldEditQueryParams(LogBlock logblock, CommandSender sender, List<String> args) throws IllegalArgumentException {
        super(logblock);
        this.parseArgs(sender, args);
    }

    @Override
    public String getQuery() {
        if (this.bct == QueryParams.BlockChangeType.CHAT) {
            String select = "SELECT ";
            if (this.needCount) {
                select = select + "COUNT(*) AS count";
            } else {
                if (this.needId) {
                    select = select + "id, ";
                }
                if (this.needDate) {
                    select = select + "date, ";
                }
                if (this.needPlayer) {
                    select = select + "playername, ";
                }
                if (this.needMessage) {
                    select = select + "message, ";
                }
                select = select.substring(0, select.length() - 2);
            }
            String from = "FROM `lb-chat` ";
            if (this.needPlayer || this.players.size() > 0) {
                from = from + "INNER JOIN `lb-players` USING (playerid) ";
            }
            return select + " " + from + this.getWhere() + "ORDER BY date " + (Object)((Object)this.order) + ", id " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        if (this.sum == QueryParams.SummarizationMode.NONE) {
            String select = "SELECT ";
            if (this.needCount) {
                select = select + "COUNT(*) AS count";
            } else {
                if (this.needId) {
                    select = select + "`" + this.getTable() + "`.id, ";
                }
                if (this.needDate) {
                    select = select + "date, ";
                }
                if (this.needType) {
                    select = select + "replaced, type, ";
                }
                if (this.needData) {
                    select = select + "data, ";
                }
                if (this.needPlayer) {
                    select = select + "playername, ";
                }
                if (this.needCoords) {
                    select = select + "x, y, z, ";
                }
                if (this.needSignText) {
                    select = select + "signtext, ";
                }
                if (this.needChestAccess) {
                    select = select + "itemtype, itemamount, itemdata, ";
                }
                select = select.substring(0, select.length() - 2);
            }
            String from = "FROM `" + this.getTable() + "` ";
            if (this.needPlayer || this.players.size() > 0) {
                from = from + "INNER JOIN `lb-players` USING (playerid) ";
            }
            if (this.needSignText) {
                from = from + "LEFT JOIN `" + this.getTable() + "-sign` USING (id) ";
            }
            if (this.needChestAccess) {
                from = from + "LEFT JOIN `" + this.getTable() + "-chest` USING (id) ";
            }
            return select + " " + from + this.getWhere() + "ORDER BY date " + (Object)((Object)this.order) + ", id " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        if (this.sum == QueryParams.SummarizationMode.TYPES) {
            return "SELECT type, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT type, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(QueryParams.BlockChangeType.CREATED) + "GROUP BY type) UNION (SELECT replaced AS type, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(QueryParams.BlockChangeType.DESTROYED) + "GROUP BY replaced)) AS t GROUP BY type ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        return "SELECT playername, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT playerid, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "` " + this.getWhere(QueryParams.BlockChangeType.CREATED) + "GROUP BY playerid) UNION (SELECT playerid, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "` " + this.getWhere(QueryParams.BlockChangeType.DESTROYED) + "GROUP BY playerid)) AS t INNER JOIN `lb-players` USING (playerid) GROUP BY playerid ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
    }

    @Override
    public String getTitle() {
        StringBuilder title = new StringBuilder();
        if (this.bct == QueryParams.BlockChangeType.CHESTACCESS) {
            title.append("chest accesses ");
        } else if (this.bct == QueryParams.BlockChangeType.CHAT) {
            title.append("chat messages ");
        } else {
            if (!this.types.isEmpty()) {
                String[] blocknames = new String[this.types.size()];
                for (int i = 0; i < this.types.size(); ++i) {
                    blocknames[i] = MaterialName.materialName(((Block)this.types.get(i)).getBlock());
                }
                title.append(Utils.listing(blocknames, ", ", " and ")).append(" ");
            } else {
                title.append("block ");
            }
            if (this.bct == QueryParams.BlockChangeType.CREATED) {
                title.append("creations ");
            } else if (this.bct == QueryParams.BlockChangeType.DESTROYED) {
                title.append("destructions ");
            } else {
                title.append("changes ");
            }
        }
        if (this.players.size() > 10) {
            title.append(this.excludePlayersMode ? "without" : "from").append(" many players ");
        } else if (!this.players.isEmpty()) {
            title.append(this.excludePlayersMode ? "without" : "from").append(" player").append(this.players.size() != 1 ? "s" : "").append(" ").append(Utils.listing(this.players.toArray(new String[this.players.size()]), ", ", " and ")).append(" ");
        }
        if (this.match != null && this.match.length() > 0) {
            title.append("matching '").append(this.match).append("' ");
        }
        if (this.before > 0 && this.since > 0) {
            title.append("between ").append(this.since).append(" and ").append(this.before).append(" minutes ago ");
        } else if (this.since > 0) {
            title.append("in the last ").append(this.since).append(" minutes ");
        } else if (this.before > 0) {
            title.append("more than ").append(this.before * -1).append(" minutes ago ");
        }
        if (this.loc != null) {
            if (this.radius > 0) {
                title.append("within ").append(this.radius).append(" blocks of ").append(this.prepareToolQuery ? "clicked block" : "you").append(" ");
            } else if (this.radius == 0) {
                title.append("at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ()).append(" ");
            }
        } else if (this.sel != null) {
            title.append(this.prepareToolQuery ? "at double chest " : "inside selection ");
        } else if (this.prepareToolQuery) {
            if (this.radius > 0) {
                title.append("within ").append(this.radius).append(" blocks of clicked block ");
            } else if (this.radius == 0) {
                title.append("at clicked block ");
            }
        }
        if (!(this.world == null || this.sel != null && this.prepareToolQuery)) {
            title.append("in ").append(BukkitUtils.friendlyWorldname(this.world.getName())).append(" ");
        }
        if (this.sum != QueryParams.SummarizationMode.NONE) {
            title.append("summed up by ").append(this.sum == QueryParams.SummarizationMode.TYPES ? "blocks" : "players").append(" ");
        }
        title.deleteCharAt(title.length() - 1);
        title.setCharAt(0, String.valueOf(title.charAt(0)).toUpperCase().toCharArray()[0]);
        return title.toString();
    }

    @Override
    public void merge(QueryParams p) {
        this.players = p.players;
        this.excludePlayersMode = p.excludePlayersMode;
        this.types = p.types;
        this.loc = p.loc;
        this.radius = p.radius;
        if (p instanceof WorldEditQueryParams) {
            this.sel = ((WorldEditQueryParams)p).sel;
        }
        if (p.since != 0 || this.since != Config.defaultTime) {
            this.since = p.since;
        }
        this.before = p.before;
        this.sum = p.sum;
        this.bct = p.bct;
        this.limit = p.limit;
        this.world = p.world;
        this.order = p.order;
        this.match = p.match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseArgs(CommandSender sender, List<String> args) throws IllegalArgumentException {
        Session session;
        if (args == null || args.isEmpty()) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        Session session2 = session = this.prepareToolQuery ? null : Session.getSession(sender);
        if (player != null && this.world == null) {
            this.world = player.getWorld();
        }
        for (int i = 0; i < args.size(); ++i) {
            String param = args.get(i).toLowerCase();
            String[] values = WorldEditQueryParams.getValues(args, i + 1);
            if (param.equals("last")) {
                if (session.lastQuery == null) {
                    throw new IllegalArgumentException("This is your first command, you can't use last.");
                }
                this.merge(session.lastQuery);
            } else if (param.equals("player")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                for (String playerName : values) {
                    if (playerName.length() <= 0) continue;
                    if (playerName.contains("!")) {
                        this.excludePlayersMode = true;
                    }
                    if (playerName.contains("\"")) {
                        this.players.add(playerName.replaceAll("[^a-zA-Z0-9_]", ""));
                        continue;
                    }
                    List matches = this.logblock.getServer().matchPlayer(playerName);
                    if (matches.size() > 1) {
                        throw new IllegalArgumentException("Ambiguous playername '" + param + "'");
                    }
                    this.players.add(matches.size() == 1 ? ((Player)matches.get(0)).getName() : playerName.replaceAll("[^a-zA-Z0-9_]", ""));
                }
            } else if (param.equals("block") || param.equals("type")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                for (String blockName : values) {
                    if (blockName.contains(":")) {
                        int data;
                        String[] blockNameSplit = blockName.split(":");
                        if (blockNameSplit.length > 2) {
                            throw new IllegalArgumentException("No material matching: '" + blockName + "'");
                        }
                        try {
                            data = Integer.parseInt(blockNameSplit[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Data type not a valid number: '" + blockNameSplit[1] + "'");
                        }
                        if (data > 255 || data < 0) {
                            throw new IllegalArgumentException("Data type out of range (0-255): '" + data + "'");
                        }
                        Material mat = Material.matchMaterial((String)blockNameSplit[0]);
                        if (mat == null) {
                            throw new IllegalArgumentException("No material matching: '" + blockName + "'");
                        }
                        this.types.add(new Block(mat.getId(), data));
                        continue;
                    }
                    Material mat = Material.matchMaterial((String)blockName);
                    if (mat == null) {
                        throw new IllegalArgumentException("No material matching: '" + blockName + "'");
                    }
                    this.types.add(new Block(mat.getId(), -1));
                }
            } else if (param.equals("area")) {
                if (player == null && !this.prepareToolQuery) {
                    throw new IllegalArgumentException("You have to be a player to use area");
                }
                if (values.length == 0) {
                    this.radius = Config.defaultDist;
                    if (!this.prepareToolQuery) {
                        this.loc = player.getLocation();
                    }
                } else {
                    if (!Utils.isInt(values[0])) {
                        throw new IllegalArgumentException("Not a number: '" + values[0] + "'");
                    }
                    this.radius = Integer.parseInt(values[0]);
                    if (!this.prepareToolQuery) {
                        this.loc = player.getLocation();
                    }
                }
            } else if (param.equals("selection") || param.equals("sel")) {
                if (player == null) {
                    throw new IllegalArgumentException("You have to be a player to use selection");
                }
                Plugin we = player.getServer().getPluginManager().getPlugin("WorldEdit");
                if (we == null) {
                    throw new IllegalArgumentException("WorldEdit plugin not found");
                }
                Selection selection = ((WorldEditPlugin)we).getSelection(player);
                if (selection == null) {
                    throw new IllegalArgumentException("No selection defined");
                }
                if (!(selection instanceof CuboidSelection)) {
                    throw new IllegalArgumentException("You have to define a cuboid selection");
                }
                this.setSelection(selection);
            } else if (param.equals("time") || param.equals("since")) {
                int n = this.since = values.length > 0 ? Utils.parseTimeSpec(values) : Config.defaultTime;
                if (this.since == -1) {
                    throw new IllegalArgumentException("Failed to parse time spec for '" + param + "'");
                }
            } else if (param.equals("before")) {
                int n = this.before = values.length > 0 ? Utils.parseTimeSpec(values) : Config.defaultTime;
                if (this.before == -1) {
                    throw new IllegalArgumentException("Faile to parse time spec for '" + param + "'");
                }
            } else if (param.equals("sum")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                if (values[0].startsWith("p")) {
                    this.sum = QueryParams.SummarizationMode.PLAYERS;
                } else if (values[0].startsWith("b")) {
                    this.sum = QueryParams.SummarizationMode.TYPES;
                } else {
                    if (!values[0].startsWith("n")) throw new IllegalArgumentException("Wrong summarization mode");
                    this.sum = QueryParams.SummarizationMode.NONE;
                }
            } else if (param.equals("created")) {
                this.bct = QueryParams.BlockChangeType.CREATED;
            } else if (param.equals("destroyed")) {
                this.bct = QueryParams.BlockChangeType.DESTROYED;
            } else if (param.equals("chestaccess")) {
                this.bct = QueryParams.BlockChangeType.CHESTACCESS;
            } else if (param.equals("chat")) {
                this.bct = QueryParams.BlockChangeType.CHAT;
            } else if (param.equals("all")) {
                this.bct = QueryParams.BlockChangeType.ALL;
            } else if (param.equals("limit")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + param + "'");
                }
                if (!Utils.isInt(values[0])) {
                    throw new IllegalArgumentException("Not a number: '" + values[0] + "'");
                }
                this.limit = Integer.parseInt(values[0]);
            } else if (param.equals("world")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + param + "'");
                }
                World w = sender.getServer().getWorld(values[0].replace("\"", ""));
                if (w == null) {
                    throw new IllegalArgumentException("There is no world called '" + values[0] + "'");
                }
                this.world = w;
            } else if (param.equals("asc")) {
                this.order = QueryParams.Order.ASC;
            } else if (param.equals("desc")) {
                this.order = QueryParams.Order.DESC;
            } else if (param.equals("coords")) {
                this.needCoords = true;
            } else if (param.equals("silent")) {
                this.silent = true;
            } else if (param.equals("search") || param.equals("match")) {
                if (values.length == 0) {
                    throw new IllegalArgumentException("No arguments for '" + param + "'");
                }
                this.match = Utils.join(values, " ").replace("\\", "\\\\").replace("'", "\\'");
            } else {
                String[] vectors;
                if (!param.equals("loc") && !param.equals("location")) throw new IllegalArgumentException("Not a valid argument: '" + param + "'");
                String[] stringArray = vectors = values.length == 1 ? values[0].split(":") : values;
                if (vectors.length != 3) {
                    throw new IllegalArgumentException("Wrong count arguments for '" + param + "'");
                }
                for (String vec : vectors) {
                    if (Utils.isInt(vec)) continue;
                    throw new IllegalArgumentException("Not a number: '" + vec + "'");
                }
                this.loc = new Location(null, (double)Integer.valueOf(vectors[0]).intValue(), (double)Integer.valueOf(vectors[1]).intValue(), (double)Integer.valueOf(vectors[2]).intValue());
                this.radius = 0;
            }
            i += values.length;
        }
        if (this.types.size() > 0) {
            for (Set<Integer> equivalent : BukkitUtils.getBlockEquivalents()) {
                boolean found = false;
                for (Block block : this.types) {
                    if (!equivalent.contains(block.getBlock())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                for (Integer type : equivalent) {
                    if (Block.inList(this.types, type)) continue;
                    this.types.add(new Block(type, -1));
                }
            }
        }
        if (!this.prepareToolQuery && this.bct != QueryParams.BlockChangeType.CHAT) {
            if (this.world == null) {
                throw new IllegalArgumentException("No world specified");
            }
            if (!Config.isLogged(this.world)) {
                throw new IllegalArgumentException("This world ('" + this.world.getName() + "') isn't logged");
            }
        }
        if (session == null) return;
        session.lastQuery = this.clone();
    }

    @Override
    public String getWhere() {
        return this.getWhere(this.bct);
    }

    @Override
    public String getWhere(QueryParams.BlockChangeType blockChangeType) {
        StringBuilder where = new StringBuilder("WHERE ");
        if (blockChangeType == QueryParams.BlockChangeType.CHAT) {
            if (this.match != null && this.match.length() > 0) {
                boolean unlike = this.match.startsWith("-");
                if (this.match.length() > 3 && !unlike || this.match.length() > 4) {
                    where.append("MATCH (message) AGAINST ('").append(this.match).append("' IN BOOLEAN MODE) AND ");
                } else {
                    where.append("message ").append(unlike ? "NOT " : "").append("LIKE '%").append(unlike ? this.match.substring(1) : this.match).append("%' AND ");
                }
            }
        } else {
            switch (blockChangeType) {
                case ALL: {
                    if (this.types.isEmpty()) break;
                    where.append('(');
                    for (Block block : this.types) {
                        where.append("((type = ").append(block.getBlock()).append(" OR replaced = ").append(block.getBlock());
                        if (block.getData() != -1) {
                            where.append(") AND data = ").append(block.getData());
                        } else {
                            where.append(")");
                        }
                        where.append(") OR ");
                    }
                    where.delete(where.length() - 4, where.length() - 1);
                    where.append(") AND ");
                    break;
                }
                case BOTH: {
                    if (!this.types.isEmpty()) {
                        where.append('(');
                        for (Block block : this.types) {
                            where.append("((type = ").append(block.getBlock()).append(" OR replaced = ").append(block.getBlock());
                            if (block.getData() != -1) {
                                where.append(") AND data = ").append(block.getData());
                            } else {
                                where.append(")");
                            }
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    }
                    where.append("type != replaced AND ");
                    break;
                }
                case CREATED: {
                    if (!this.types.isEmpty()) {
                        where.append('(');
                        for (Block block : this.types) {
                            where.append("((type = ").append(block.getBlock());
                            if (block.getData() != -1) {
                                where.append(") AND data = ").append(block.getData());
                            } else {
                                where.append(")");
                            }
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    } else {
                        where.append("type != 0 AND ");
                    }
                    where.append("type != replaced AND ");
                    break;
                }
                case DESTROYED: {
                    if (!this.types.isEmpty()) {
                        where.append('(');
                        for (Block block : this.types) {
                            where.append("((replaced = ").append(block.getBlock());
                            if (block.getData() != -1) {
                                where.append(") AND data = ").append(block.getData());
                            } else {
                                where.append(")");
                            }
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    } else {
                        where.append("replaced != 0 AND ");
                    }
                    where.append("type != replaced AND ");
                    break;
                }
                case CHESTACCESS: {
                    where.append("(type = 23 OR type = 54 OR type = 61 OR type = 62) AND type = replaced AND ");
                    if (this.types.isEmpty()) break;
                    where.append('(');
                    for (Block block : this.types) {
                        where.append("((itemtype = ").append(block.getBlock());
                        if (block.getData() != -1) {
                            where.append(") AND itemdata = ").append(block.getData());
                        } else {
                            where.append(")");
                        }
                        where.append(") OR ");
                    }
                    where.delete(where.length() - 4, where.length());
                    where.append(") AND ");
                }
            }
            if (this.loc != null) {
                if (this.radius == 0) {
                    where.append("x = '").append(this.loc.getBlockX()).append("' AND y = '").append(this.loc.getBlockY()).append("' AND z = '").append(this.loc.getBlockZ()).append("' AND ");
                } else if (this.radius > 0) {
                    where.append("x > '").append(this.loc.getBlockX() - this.radius).append("' AND x < '").append(this.loc.getBlockX() + this.radius).append("' AND z > '").append(this.loc.getBlockZ() - this.radius).append("' AND z < '").append(this.loc.getBlockZ() + this.radius).append("' AND ");
                }
            } else if (this.sel != null) {
                where.append("x >= '").append(this.sel.getMinimumPoint().getBlockX()).append("' AND x <= '").append(this.sel.getMaximumPoint().getBlockX()).append("' AND y >= '").append(this.sel.getMinimumPoint().getBlockY()).append("' AND y <= '").append(this.sel.getMaximumPoint().getBlockY()).append("' AND z >= '").append(this.sel.getMinimumPoint().getBlockZ()).append("' AND z <= '").append(this.sel.getMaximumPoint().getBlockZ()).append("' AND ");
            }
        }
        if (!this.players.isEmpty() && this.sum != QueryParams.SummarizationMode.PLAYERS) {
            if (!this.excludePlayersMode) {
                where.append('(');
                for (String playerName : this.players) {
                    where.append("playername = '").append(playerName).append("' OR ");
                }
                where.delete(where.length() - 4, where.length());
                where.append(") AND ");
            } else {
                for (String playerName : this.players) {
                    where.append("playername != '").append(playerName).append("' AND ");
                }
            }
        }
        if (this.since > 0) {
            where.append("date > date_sub(now(), INTERVAL ").append(this.since).append(" MINUTE) AND ");
        }
        if (this.before > 0) {
            where.append("date < date_sub(now(), INTERVAL ").append(this.before).append(" MINUTE) AND ");
        }
        if (where.length() > 6) {
            where.delete(where.length() - 4, where.length());
        } else {
            where.delete(0, where.length());
        }
        return where.toString();
    }

    @Override
    public void setSelection(Selection sel) {
        this.sel = sel;
        this.world = sel.getWorld();
    }

    public void setSelection(World world, Location location, Location location2) {
        this.setSelection((Selection)new CuboidSelection(world, location, location2));
    }
}

