/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.MaterialName;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Bed;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PistonExtensionMaterial;
import org.bukkit.plugin.Plugin;

public class WorldEditor
implements Runnable {
    private final LogBlock logblock;
    private final Queue<Edit> edits = new LinkedBlockingQueue<Edit>();
    private final World world;
    private int taskID;
    private int successes = 0;
    private int blacklistCollisions = 0;
    private long elapsedTime = 0L;
    public LookupCacheElement[] errors;

    public WorldEditor(LogBlock logblock, World world) {
        this.logblock = logblock;
        this.world = world;
    }

    public int getSize() {
        return this.edits.size();
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getErrors() {
        return this.errors.length;
    }

    public int getBlacklistCollisions() {
        return this.blacklistCollisions;
    }

    public void queueEdit(int x, int y, int z, int replaced, int type, byte data, String signtext, short itemType, short itemAmount, byte itemData) {
        this.edits.add(new Edit(0L, new Location(this.world, (double)x, (double)y, (double)z), null, replaced, type, data, signtext, new ChestAccess(itemType, itemAmount, itemData)));
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public synchronized void start() throws Exception {
        long start = System.currentTimeMillis();
        this.taskID = this.logblock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.logblock, (Runnable)this, 0L, 1L);
        if (this.taskID == -1) {
            throw new Exception("Failed to schedule task");
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            throw new Exception("Interrupted");
        }
        this.elapsedTime = System.currentTimeMillis() - start;
    }

    @Override
    public synchronized void run() {
        ArrayList<WorldEditorException> errorList = new ArrayList<WorldEditorException>();
        for (int counter = 0; !this.edits.isEmpty() && counter < 100; ++counter) {
            try {
                switch (this.edits.poll().perform()) {
                    case SUCCESS: {
                        ++this.successes;
                        break;
                    }
                    case BLACKLISTED: {
                        ++this.blacklistCollisions;
                    }
                }
                continue;
            }
            catch (WorldEditorException ex) {
                errorList.add(ex);
                continue;
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "[LogBlock WorldEditor] Exeption: ", ex);
            }
        }
        if (this.edits.isEmpty()) {
            this.logblock.getServer().getScheduler().cancelTask(this.taskID);
            if (errorList.size() > 0) {
                try {
                    File file = new File("plugins/LogBlock/error/WorldEditor-" + new SimpleDateFormat("yy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + ".log");
                    file.getParentFile().mkdirs();
                    PrintWriter writer = new PrintWriter(file);
                    for (WorldEditorException err : errorList) {
                        writer.println(err.getMessage());
                    }
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.errors = errorList.toArray(new WorldEditorException[errorList.size()]);
            this.notify();
        }
    }

    public static class WorldEditorException
    extends Exception
    implements LookupCacheElement {
        private final Location loc;

        public WorldEditorException(int typeBefore, int typeAfter, Location loc) {
            this("Failed to replace " + MaterialName.materialName(typeBefore) + " with " + MaterialName.materialName(typeAfter), loc);
        }

        public WorldEditorException(String msg, Location loc) {
            super(msg + " at " + loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ());
            this.loc = loc;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }
    }

    private class Edit
    extends BlockChange {
        public Edit(long time, Location loc, String playerName, int replaced, int type, byte data, String signtext, ChestAccess ca) {
            super(time, loc, playerName, replaced, type, data, signtext, ca);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        PerformResult perform() throws WorldEditorException {
            if (Config.dontRollback.contains(this.replaced)) {
                return PerformResult.BLACKLISTED;
            }
            Block block = this.loc.getBlock();
            if (this.replaced == 0 && block.getTypeId() == 0) {
                return PerformResult.NO_ACTION;
            }
            BlockState state = block.getState();
            if (!WorldEditor.this.world.isChunkLoaded(block.getChunk())) {
                WorldEditor.this.world.loadChunk(block.getChunk());
            }
            if (this.type == this.replaced) {
                if (this.type == 0) {
                    if (block.setTypeId(0)) return PerformResult.SUCCESS;
                    throw new WorldEditorException(block.getTypeId(), 0, block.getLocation());
                }
                if (this.ca == null || this.type != 23 && this.type != 54 && this.type != 61 && this.type != 62) return PerformResult.NO_ACTION;
                int leftover = 0;
                try {
                    leftover = BukkitUtils.modifyContainer(state, new ItemStack((int)this.ca.itemType, (int)(-this.ca.itemAmount), 0, Byte.valueOf(this.ca.itemData)));
                    if (leftover > 0) {
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            if (block.getRelative(face).getTypeId() != 54) continue;
                            leftover = BukkitUtils.modifyContainer(block.getRelative(face).getState(), new ItemStack((int)this.ca.itemType, this.ca.itemAmount < 0 ? leftover : -leftover, 0, Byte.valueOf(this.ca.itemData)));
                        }
                    }
                }
                catch (Exception ex) {
                    throw new WorldEditorException(ex.getMessage(), block.getLocation());
                }
                if (!state.update()) {
                    throw new WorldEditorException("Failed to update inventory of " + MaterialName.materialName(block.getTypeId()), block.getLocation());
                }
                if (leftover <= 0 || this.ca.itemAmount >= 0) return PerformResult.SUCCESS;
                throw new WorldEditorException("Not enough space left in " + MaterialName.materialName(block.getTypeId()), block.getLocation());
            }
            if (!BukkitUtils.equalTypes(block.getTypeId(), this.type) && !Config.replaceAnyway.contains(block.getTypeId())) {
                return PerformResult.NO_ACTION;
            }
            if (state instanceof InventoryHolder) {
                ((InventoryHolder)state).getInventory().clear();
                state.update();
            }
            if (block.getTypeId() == this.replaced) {
                if (block.getData() == (this.type == 0 ? this.data : (byte)0)) return PerformResult.NO_ACTION;
                block.setData(this.type == 0 ? this.data : (byte)0, true);
            } else if (!block.setTypeIdAndData(this.replaced, this.type == 0 ? this.data : (byte)0, true)) {
                throw new WorldEditorException(block.getTypeId(), this.replaced, block.getLocation());
            }
            int curtype = block.getTypeId();
            if (this.signtext != null && (curtype == 63 || curtype == 68)) {
                Sign sign = (Sign)block.getState();
                String[] lines = this.signtext.split("\u0000", 4);
                if (lines.length < 4) {
                    return PerformResult.NO_ACTION;
                }
                for (int i = 0; i < 4; ++i) {
                    sign.setLine(i, lines[i]);
                }
                if (sign.update()) return PerformResult.SUCCESS;
                throw new WorldEditorException("Failed to update signtext of " + MaterialName.materialName(block.getTypeId()), block.getLocation());
            }
            if (curtype == 26) {
                Block secBlock;
                Bed bed = (Bed)block.getState().getData();
                Block block2 = secBlock = bed.isHeadOfBed() ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                if (secBlock.getTypeId() != 0 || secBlock.setTypeIdAndData(26, (byte)(bed.getData() | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(secBlock.getTypeId(), 26, secBlock.getLocation());
            }
            if (curtype == 64 || curtype == 71) {
                Block secBlock;
                byte blockData = block.getData();
                Block block3 = secBlock = (blockData & 8) == 8 ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
                if (secBlock.getTypeId() != 0 || secBlock.setTypeIdAndData(curtype, (byte)(blockData | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(secBlock.getTypeId(), curtype, secBlock.getLocation());
            }
            if ((curtype == 29 || curtype == 33) && (block.getData() & 8) > 0) {
                PistonBaseMaterial piston = (PistonBaseMaterial)block.getState().getData();
                Block secBlock = block.getRelative(piston.getFacing());
                if (secBlock.getTypeId() != 0 || secBlock.setTypeIdAndData(34, curtype == 29 ? (byte)(block.getData() | 8) : (byte)(block.getData() & 0xFFFFFFF7), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(secBlock.getTypeId(), 34, secBlock.getLocation());
            }
            if (curtype == 34) {
                PistonExtensionMaterial piston = (PistonExtensionMaterial)block.getState().getData();
                Block secBlock = block.getRelative(piston.getFacing().getOppositeFace());
                if (secBlock.getTypeId() != 0 || secBlock.setTypeIdAndData(piston.isSticky() ? 29 : 33, (byte)(block.getData() | 8), true)) return PerformResult.SUCCESS;
                throw new WorldEditorException(secBlock.getTypeId(), piston.isSticky() ? 29 : 33, secBlock.getLocation());
            }
            if (curtype != 18 || (block.getData() & 8) <= 0) return PerformResult.SUCCESS;
            block.setData((byte)(block.getData() & 0xF7));
            return PerformResult.SUCCESS;
        }
    }

    private static enum PerformResult {
        SUCCESS,
        BLACKLISTED,
        NO_ACTION;

    }
}

