/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.config;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolBehavior;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.config.LoggingEnabledMapping;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.PermissionDefault;

public class Config {
    private static LoggingEnabledMapping superWorldConfig;
    private static Map<String, WorldConfig> worldConfigs;
    public static String url;
    public static String user;
    public static String password;
    public static int delayBetweenRuns;
    public static int forceToProcessAtLeast;
    public static int timePerRun;
    public static boolean useBukkitScheduler;
    public static boolean enableAutoClearLog;
    public static List<String> autoClearLog;
    public static int autoClearLogDelay;
    public static boolean dumpDeletedLog;
    public static boolean logCreeperExplosionsAsPlayerWhoTriggeredThese;
    public static boolean logPlayerInfo;
    public static LogKillsLevel logKillsLevel;
    public static Set<Integer> dontRollback;
    public static Set<Integer> replaceAnyway;
    public static int rollbackMaxTime;
    public static int rollbackMaxArea;
    public static Map<String, Tool> toolsByName;
    public static Map<Integer, Tool> toolsByType;
    public static int defaultDist;
    public static int defaultTime;
    public static int linesPerPage;
    public static int linesLimit;
    public static boolean askRollbacks;
    public static boolean askRedos;
    public static boolean askClearLogs;
    public static boolean askClearLogAfterRollback;
    public static boolean askRollbackAfterBan;
    public static String banPermission;
    public static Set<Integer> hiddenBlocks;
    public static Set<String> hiddenPlayers;
    public static Set<String> ignoredChat;

    public static void load(LogBlock logblock) throws DataFormatException, IOException {
        FileConfiguration config = logblock.getConfig();
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("version", logblock.getDescription().getVersion());
        ArrayList<String> worldNames = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            worldNames.add(world.getName());
        }
        if (worldNames.isEmpty()) {
            worldNames.add("world");
            worldNames.add("world_nether");
            worldNames.add("world_the_end");
        }
        def.put("loggedWorlds", worldNames);
        def.put("mysql.host", "localhost");
        def.put("mysql.port", 3306);
        def.put("mysql.database", "minecraft");
        def.put("mysql.user", "username");
        def.put("mysql.password", "pass");
        def.put("consumer.delayBetweenRuns", 6);
        def.put("consumer.forceToProcessAtLeast", 20);
        def.put("consumer.timePerRun", 200);
        def.put("consumer.useBukkitScheduler", true);
        def.put("clearlog.dumpDeletedLog", false);
        def.put("clearlog.enableAutoClearLog", false);
        def.put("clearlog.auto", Arrays.asList("world \"world\" before 365 days all", "world \"world\" player lavaflow waterflow leavesdecay before 7 days all", "world world_nether before 365 days all", "world world_nether player lavaflow before 7 days all"));
        def.put("clearlog.autoClearLogDelay", "6h");
        def.put("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        def.put("logging.logKillsLevel", "PLAYERS");
        def.put("logging.logPlayerInfo", false);
        def.put("logging.hiddenPlayers", new ArrayList());
        def.put("logging.hiddenBlocks", Arrays.asList(0));
        def.put("logging.ignoredChat", Arrays.asList("/register", "/login"));
        def.put("rollback.dontRollback", Arrays.asList(10, 11, 46, 51));
        def.put("rollback.replaceAnyway", Arrays.asList(8, 9, 10, 11, 51));
        def.put("rollback.maxTime", "2 days");
        def.put("rollback.maxArea", 50);
        def.put("lookup.defaultDist", 20);
        def.put("lookup.defaultTime", "30 minutes");
        def.put("lookup.linesPerPage", 15);
        def.put("lookup.linesLimit", 1500);
        def.put("questioner.askRollbacks", true);
        def.put("questioner.askRedos", true);
        def.put("questioner.askClearLogs", true);
        def.put("questioner.askClearLogAfterRollback", true);
        def.put("questioner.askRollbackAfterBan", false);
        def.put("questioner.banPermission", "mcbans.ban.local");
        def.put("tools.tool.aliases", Arrays.asList("t"));
        def.put("tools.tool.leftClickBehavior", "NONE");
        def.put("tools.tool.rightClickBehavior", "TOOL");
        def.put("tools.tool.defaultEnabled", true);
        def.put("tools.tool.item", 270);
        def.put("tools.tool.canDrop", true);
        def.put("tools.tool.params", "area 0 all sum none limit 15 desc silent");
        def.put("tools.tool.mode", "LOOKUP");
        def.put("tools.tool.permissionDefault", "OP");
        def.put("tools.toolblock.aliases", Arrays.asList("tb"));
        def.put("tools.toolblock.leftClickBehavior", "TOOL");
        def.put("tools.toolblock.rightClickBehavior", "BLOCK");
        def.put("tools.toolblock.defaultEnabled", true);
        def.put("tools.toolblock.item", 7);
        def.put("tools.toolblock.canDrop", false);
        def.put("tools.toolblock.params", "area 0 all sum none limit 15 desc silent");
        def.put("tools.toolblock.mode", "LOOKUP");
        def.put("tools.toolblock.permissionDefault", "OP");
        for (Map.Entry entry : def.entrySet()) {
            if (config.contains((String)entry.getKey())) continue;
            config.set((String)entry.getKey(), entry.getValue());
        }
        logblock.saveConfig();
        url = "jdbc:mysql://" + config.getString("mysql.host") + ":" + config.getInt("mysql.port") + "/" + Config.getStringIncludingInts((ConfigurationSection)config, "mysql.database");
        user = Config.getStringIncludingInts((ConfigurationSection)config, "mysql.user");
        password = Config.getStringIncludingInts((ConfigurationSection)config, "mysql.password");
        delayBetweenRuns = config.getInt("consumer.delayBetweenRuns", 6);
        forceToProcessAtLeast = config.getInt("consumer.forceToProcessAtLeast", 0);
        timePerRun = config.getInt("consumer.timePerRun", 100);
        useBukkitScheduler = config.getBoolean("consumer.useBukkitScheduler", true);
        enableAutoClearLog = config.getBoolean("clearlog.enableAutoClearLog");
        autoClearLog = config.getStringList("clearlog.auto");
        dumpDeletedLog = config.getBoolean("clearlog.dumpDeletedLog", false);
        autoClearLogDelay = Utils.parseTimeSpec(config.getString("clearlog.autoClearLogDelay").split(" "));
        logCreeperExplosionsAsPlayerWhoTriggeredThese = config.getBoolean("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        logPlayerInfo = config.getBoolean("logging.logPlayerInfo", true);
        try {
            logKillsLevel = LogKillsLevel.valueOf(config.getString("logging.logKillsLevel").toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new DataFormatException("lookup.toolblockID doesn't appear to be a valid log level. Allowed are 'PLAYERS', 'MONSTERS' and 'ANIMALS'");
        }
        hiddenPlayers = new HashSet<String>();
        for (String string : config.getStringList("logging.hiddenPlayers")) {
            hiddenPlayers.add(string);
        }
        hiddenBlocks = new HashSet<Integer>();
        for (Object object : config.getList("logging.hiddenBlocks")) {
            Material mat = Material.matchMaterial((String)String.valueOf(object));
            if (mat != null) {
                hiddenBlocks.add(mat.getId());
                continue;
            }
            throw new DataFormatException("Not a valid material: '" + object + "'");
        }
        ignoredChat = new HashSet<String>();
        for (String string : config.getStringList("logging.ignoredChat")) {
            ignoredChat.add(string);
        }
        dontRollback = new HashSet<Integer>(config.getIntegerList("rollback.dontRollback"));
        replaceAnyway = new HashSet<Integer>(config.getIntegerList("rollback.replaceAnyway"));
        rollbackMaxTime = Utils.parseTimeSpec(config.getString("rollback.maxTime").split(" "));
        rollbackMaxArea = config.getInt("rollback.maxArea", 50);
        defaultDist = config.getInt("lookup.defaultDist", 20);
        defaultTime = Utils.parseTimeSpec(config.getString("lookup.defaultTime").split(" "));
        linesPerPage = config.getInt("lookup.linesPerPage", 15);
        linesLimit = config.getInt("lookup.linesLimit", 1500);
        askRollbacks = config.getBoolean("questioner.askRollbacks", true);
        askRedos = config.getBoolean("questioner.askRedos", true);
        askClearLogs = config.getBoolean("questioner.askClearLogs", true);
        askClearLogAfterRollback = config.getBoolean("questioner.askClearLogAfterRollback", true);
        askRollbackAfterBan = config.getBoolean("questioner.askRollbackAfterBan", false);
        banPermission = config.getString("questioner.banPermission");
        ArrayList<Tool> tools = new ArrayList<Tool>();
        ConfigurationSection configurationSection = config.getConfigurationSection("tools");
        for (String toolName : configurationSection.getKeys(false)) {
            try {
                ConfigurationSection tSec = configurationSection.getConfigurationSection(toolName);
                List aliases = tSec.getStringList("aliases");
                ToolBehavior leftClickBehavior = ToolBehavior.valueOf(tSec.getString("leftClickBehavior").toUpperCase());
                ToolBehavior rightClickBehavior = ToolBehavior.valueOf(tSec.getString("rightClickBehavior").toUpperCase());
                boolean defaultEnabled = tSec.getBoolean("defaultEnabled", false);
                int item = tSec.getInt("item", 0);
                boolean canDrop = tSec.getBoolean("canDrop", false);
                QueryParams params = new QueryParams(logblock);
                params.prepareToolQuery = true;
                params.parseArgs((CommandSender)Bukkit.getConsoleSender(), Arrays.asList(tSec.getString("params").split(" ")));
                ToolMode mode = ToolMode.valueOf(tSec.getString("mode").toUpperCase());
                PermissionDefault pdef = PermissionDefault.valueOf((String)tSec.getString("permissionDefault").toUpperCase());
                tools.add(new Tool(toolName, aliases, leftClickBehavior, rightClickBehavior, defaultEnabled, item, canDrop, params, mode, pdef));
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error at parsing tool '" + toolName + "': ", ex);
            }
        }
        toolsByName = new HashMap<String, Tool>();
        toolsByType = new HashMap<Integer, Tool>();
        for (Tool tool : tools) {
            toolsByType.put(tool.item, tool);
            toolsByName.put(tool.name.toLowerCase(), tool);
            for (String alias : tool.aliases) {
                toolsByName.put(alias, tool);
            }
        }
        List loggedWorlds = config.getStringList("loggedWorlds");
        worldConfigs = new HashMap<String, WorldConfig>();
        if (loggedWorlds.isEmpty()) {
            throw new DataFormatException("No worlds configured");
        }
        for (String world : loggedWorlds) {
            worldConfigs.put(world, new WorldConfig(new File(logblock.getDataFolder(), BukkitUtils.friendlyWorldname(world) + ".yml")));
        }
        superWorldConfig = new LoggingEnabledMapping();
        for (WorldConfig wcfg : worldConfigs.values()) {
            for (Logging l : Logging.values()) {
                if (!wcfg.isLogging(l)) continue;
                superWorldConfig.setLogging(l, true);
            }
        }
    }

    private static String getStringIncludingInts(ConfigurationSection cfg, String key) {
        String str = cfg.getString(key);
        if (str == null) {
            str = String.valueOf(cfg.getInt(key));
        }
        if (str == null) {
            str = "No value set for '" + key + "'";
        }
        return str;
    }

    public static boolean isLogging(World world, Logging l) {
        WorldConfig wcfg = worldConfigs.get(world.getName());
        return wcfg != null && wcfg.isLogging(l);
    }

    public static boolean isLogged(World world) {
        return worldConfigs.containsKey(world.getName());
    }

    public static WorldConfig getWorldConfig(World world) {
        return worldConfigs.get(world.getName());
    }

    public static WorldConfig getWorldConfig(String world) {
        return worldConfigs.get(world);
    }

    public static boolean isLogging(Logging l) {
        return superWorldConfig.isLogging(l);
    }

    public static Collection<WorldConfig> getLoggedWorlds() {
        return worldConfigs.values();
    }

    public static enum LogKillsLevel {
        PLAYERS,
        MONSTERS,
        ANIMALS;

    }
}

