/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class BlockBreakLogging
extends LoggingListener {
    public BlockBreakLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
        if (wcfg != null && wcfg.isLogging(Logging.BLOCKBREAK)) {
            int type = event.getBlock().getTypeId();
            if (wcfg.isLogging(Logging.SIGNTEXT) && (type == 63 || type == 68)) {
                this.consumer.queueSignBreak(event.getPlayer().getName(), (Sign)event.getBlock().getState());
            } else if (wcfg.isLogging(Logging.CHESTACCESS) && (type == 23 || type == 54 || type == 61)) {
                this.consumer.queueContainerBreak(event.getPlayer().getName(), event.getBlock().getState());
            } else if (type == 79) {
                this.consumer.queueBlockReplace(event.getPlayer().getName(), event.getBlock().getState(), 9, (byte)0);
            } else {
                this.consumer.queueBlockBreak(event.getPlayer().getName(), event.getBlock().getState());
                List<Location> nearbySigns = BukkitUtils.getBlocksNearby(event.getBlock(), BukkitUtils.getRelativeBreakables());
                if (nearbySigns.size() != 0) {
                    for (Location location : nearbySigns) {
                        int blockType = location.getBlock().getTypeId();
                        if (wcfg.isLogging(Logging.SIGNTEXT) && (blockType == 63 || type == 68)) {
                            this.consumer.queueSignBreak(event.getPlayer().getName(), (Sign)location.getBlock().getState());
                        }
                        this.consumer.queueBlockBreak(event.getPlayer().getName(), location.getBlock().getState());
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (Config.isLogging(event.getPlayer().getWorld(), Logging.BLOCKBREAK)) {
            this.consumer.queueBlockBreak(event.getPlayer().getName(), event.getBlockClicked().getState());
        }
    }
}

