/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class BlockPlaceLogging
extends LoggingListener {
    public BlockPlaceLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getBlock().getWorld());
        if (wcfg != null && wcfg.isLogging(Logging.BLOCKPLACE)) {
            int type = event.getBlock().getTypeId();
            final BlockState before = event.getBlockReplacedState();
            final BlockState after = event.getBlockPlaced().getState();
            final String playerName = event.getPlayer().getName();
            if (type == 0 && event.getItemInHand() != null) {
                if (event.getItemInHand().getTypeId() == 51) {
                    return;
                }
                after.setTypeId(event.getItemInHand().getTypeId());
                after.setData(new MaterialData(event.getItemInHand().getTypeId()));
            }
            if (wcfg.isLogging(Logging.SIGNTEXT) && (type == 63 || type == 68)) {
                return;
            }
            LogBlock.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)LogBlock.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (before.getTypeId() == 0) {
                        BlockPlaceLogging.this.consumer.queueBlockPlace(playerName, after);
                    } else {
                        BlockPlaceLogging.this.consumer.queueBlockReplace(playerName, before, after);
                    }
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (Config.isLogging(event.getPlayer().getWorld(), Logging.BLOCKPLACE)) {
            this.consumer.queueBlockPlace(event.getPlayer().getName(), event.getBlockClicked().getRelative(event.getBlockFace()).getLocation(), event.getBucket() == Material.WATER_BUCKET ? 9 : 11, (byte)0);
        }
    }
}

