/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionLogging
extends LoggingListener {
    public ExplosionLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getLocation().getWorld());
        if (wcfg != null) {
            String name;
            if (event.getEntity() == null) {
                if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                    return;
                }
                name = "Explosion";
            } else if (event.getEntity() instanceof TNTPrimed) {
                if (!wcfg.isLogging(Logging.TNTEXPLOSION)) {
                    return;
                }
                name = "TNT";
            } else if (event.getEntity() instanceof Creeper) {
                LivingEntity target;
                if (!wcfg.isLogging(Logging.CREEPEREXPLOSION)) {
                    return;
                }
                name = Config.logCreeperExplosionsAsPlayerWhoTriggeredThese ? ((target = ((Creeper)event.getEntity()).getTarget()) instanceof Player ? ((Player)target).getName() : "Creeper") : "Creeper";
            } else if (event.getEntity() instanceof Fireball) {
                if (!wcfg.isLogging(Logging.GHASTFIREBALLEXPLOSION)) {
                    return;
                }
                name = "Ghast";
            } else if (event.getEntity() instanceof EnderDragon) {
                if (!wcfg.isLogging(Logging.ENDERDRAGON)) {
                    return;
                }
                name = "EnderDragon";
            } else {
                if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                    return;
                }
                name = "Explosion";
            }
            for (Block block : event.blockList()) {
                int type = block.getTypeId();
                if (wcfg.isLogging(Logging.SIGNTEXT) & (type == 63 || type == 68)) {
                    this.consumer.queueSignBreak(name, (Sign)block.getState());
                    continue;
                }
                if (wcfg.isLogging(Logging.CHESTACCESS) && (type == 23 || type == 54 || type == 61)) {
                    this.consumer.queueContainerBreak(name, block.getState());
                    continue;
                }
                this.consumer.queueBlockBreak(name, block.getState());
            }
        }
    }
}

