/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockFromToEvent;

public class FluidFlowLogging
extends LoggingListener {
    private static final Set<Integer> nonFluidProofBlocks = new HashSet<Integer>(Arrays.asList(27, 28, 31, 32, 37, 38, 39, 40, 50, 51, 55, 59, 66, 69, 70, 75, 76, 78, 93, 94, 104, 105, 106));

    public FluidFlowLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        block19: {
            int typeTo;
            int typeFrom;
            Block to;
            WorldConfig wcfg;
            block20: {
                block21: {
                    boolean canFlow;
                    wcfg = Config.getWorldConfig(event.getBlock().getWorld());
                    if (wcfg == null) break block19;
                    to = event.getToBlock();
                    typeFrom = event.getBlock().getTypeId();
                    typeTo = to.getTypeId();
                    boolean bl = canFlow = typeTo == 0 || nonFluidProofBlocks.contains(typeTo);
                    if (typeFrom != 10 && typeFrom != 11) break block20;
                    if (!canFlow) break block21;
                    if (FluidFlowLogging.isSurroundedByWater(to) && event.getBlock().getData() <= 2) {
                        this.consumer.queueBlockReplace("LavaFlow", to.getState(), 4, (byte)0);
                    } else if (typeTo == 0) {
                        if (wcfg.isLogging(Logging.LAVAFLOW)) {
                            this.consumer.queueBlockPlace("LavaFlow", to.getLocation(), 10, (byte)(event.getBlock().getData() + 1));
                        }
                    } else {
                        this.consumer.queueBlockReplace("LavaFlow", to.getState(), 10, (byte)(event.getBlock().getData() + 1));
                    }
                    break block19;
                }
                if (typeTo != 8 && typeTo != 9) break block19;
                if (event.getFace() == BlockFace.DOWN) {
                    this.consumer.queueBlockReplace("LavaFlow", to.getState(), 1, (byte)0);
                } else {
                    this.consumer.queueBlockReplace("LavaFlow", to.getState(), 4, (byte)0);
                }
                break block19;
            }
            if (typeFrom == 8 || typeFrom == 9) {
                if (typeTo == 0) {
                    if (wcfg.isLogging(Logging.WATERFLOW)) {
                        this.consumer.queueBlockPlace("WaterFlow", to.getLocation(), 8, (byte)(event.getBlock().getData() + 1));
                    }
                } else if (nonFluidProofBlocks.contains(typeTo)) {
                    this.consumer.queueBlockReplace("WaterFlow", to.getState(), 8, (byte)(event.getBlock().getData() + 1));
                } else if (typeTo == 10 || typeTo == 11) {
                    if (to.getData() == 0) {
                        this.consumer.queueBlockReplace("WaterFlow", to.getState(), 49, (byte)0);
                    } else if (event.getFace() == BlockFace.DOWN) {
                        this.consumer.queueBlockReplace("LavaFlow", to.getState(), 1, (byte)0);
                    }
                }
                if (typeTo == 0 || nonFluidProofBlocks.contains(typeTo)) {
                    for (BlockFace face : new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
                        Block lower = to.getRelative(face);
                        if (lower.getTypeId() != 10 && lower.getTypeId() != 11) continue;
                        this.consumer.queueBlockReplace("WaterFlow", lower.getState(), lower.getData() == 0 ? 49 : 4, (byte)0);
                    }
                }
            }
        }
    }

    private static boolean isSurroundedByWater(Block block) {
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
            int type = block.getRelative(face).getTypeId();
            if (type != 8 && type != 9) continue;
            return true;
        }
        return false;
    }
}

