/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class InteractLogging
extends LoggingListener {
    public InteractLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getPlayer().getWorld());
        if (wcfg != null && (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            Material type = event.getClickedBlock().getType();
            int typeId = type.getId();
            byte blockData = event.getClickedBlock().getData();
            Player player = event.getPlayer();
            Location loc = event.getClickedBlock().getLocation();
            switch (type) {
                case LEVER: 
                case STONE_BUTTON: {
                    if (!wcfg.isLogging(Logging.SWITCHINTERACT)) break;
                    this.consumer.queueBlock(player.getName(), loc, typeId, typeId, blockData);
                    break;
                }
                case FENCE_GATE: {
                    if (event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                }
                case WOODEN_DOOR: 
                case TRAP_DOOR: {
                    if (!wcfg.isLogging(Logging.DOORINTERACT)) break;
                    this.consumer.queueBlock(player.getName(), loc, typeId, typeId, blockData);
                    break;
                }
                case CAKE_BLOCK: {
                    if (!wcfg.isLogging(Logging.CAKEEAT) || player.getFoodLevel() >= 20) break;
                    this.consumer.queueBlock(player.getName(), loc, typeId, typeId, blockData);
                    break;
                }
                case NOTE_BLOCK: {
                    if (!wcfg.isLogging(Logging.NOTEBLOCKINTERACT)) break;
                    this.consumer.queueBlock(player.getName(), loc, typeId, typeId, blockData);
                    break;
                }
                case DIODE_BLOCK_OFF: 
                case DIODE_BLOCK_ON: {
                    if (!wcfg.isLogging(Logging.DIODEINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(player.getName(), loc, typeId, typeId, blockData);
                }
            }
        }
    }
}

