/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class KillLogging
extends LoggingListener {
    private final Map<Integer, Integer> lastAttackedEntity = new HashMap<Integer, Integer>();
    private final Map<Integer, Long> lastAttackTime = new HashMap<Integer, Long>();

    public KillLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (Config.isLogging(event.getEntity().getWorld(), Logging.KILL) && event instanceof EntityDamageByEntityEvent && event.getEntity() instanceof LivingEntity) {
            LivingEntity victim = (LivingEntity)event.getEntity();
            Entity killer = ((EntityDamageByEntityEvent)event).getDamager();
            if (victim.getHealth() - event.getDamage() > 0 || victim.getHealth() <= 0) {
                return;
            }
            if (!(Config.logKillsLevel != Config.LogKillsLevel.PLAYERS || victim instanceof Player && killer instanceof Player)) {
                return;
            }
            if (!(Config.logKillsLevel != Config.LogKillsLevel.MONSTERS || (victim instanceof Player || victim instanceof Monster) && killer instanceof Player || killer instanceof Monster)) {
                return;
            }
            if (this.lastAttackedEntity.containsKey(killer.getEntityId()) && this.lastAttackedEntity.get(killer.getEntityId()).intValue() == victim.getEntityId() && System.currentTimeMillis() - this.lastAttackTime.get(killer.getEntityId()) < 5000L) {
                return;
            }
            this.consumer.queueKill(killer, (Entity)victim);
            this.lastAttackedEntity.put(killer.getEntityId(), victim.getEntityId());
            this.lastAttackTime.put(killer.getEntityId(), System.currentTimeMillis());
        }
    }
}

