/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.material.MaterialData;

public class MaterialName {
    private static final Map<Integer, String> materialNames = new HashMap<Integer, String>();
    private static final Map<Integer, Map<Byte, String>> materialDataNames = new HashMap<Integer, Map<Byte, String>>();

    public static String materialName(int type) {
        return materialNames.containsKey(type) ? materialNames.get(type) : String.valueOf(type);
    }

    public static String materialName(int type, byte data) {
        Map<Byte, String> dataNames = materialDataNames.get(type);
        if (dataNames != null && dataNames.containsKey(data)) {
            return dataNames.get(data);
        }
        return MaterialName.materialName(type);
    }

    private static String toReadable(MaterialData matData) {
        return matData.toString().toLowerCase().replace('_', ' ').replaceAll("[^a-z ]", "");
    }

    static {
        for (Material mat : Material.values()) {
            materialNames.put(mat.getId(), mat.toString().replace('_', ' ').toLowerCase());
        }
        File file = new File("plugins/LogBlock/materials.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        if (cfg.getKeys(false).isEmpty()) {
            byte i;
            cfg.options().header("Add block or item names you want to be overridden or also names for custom blocks");
            cfg.set("6.1", (Object)"redwood sapling");
            cfg.set("6.2", (Object)"birch sapling");
            cfg.set("9", (Object)"water");
            cfg.set("11", (Object)"lava");
            cfg.set("17.1", (Object)"redwood log");
            cfg.set("17.2", (Object)"birch log");
            cfg.set("18.1", (Object)"redwood leaves");
            cfg.set("18.2", (Object)"birch leaves");
            cfg.set("31.0", (Object)"dead long grass");
            cfg.set("31.2", (Object)"fern");
            for (i = 0; i < 7; i = (byte)(i + 1)) {
                cfg.set("35." + i, (Object)MaterialName.toReadable(Material.STEP.getNewData(i)));
                cfg.set("351." + i, (Object)MaterialName.toReadable(Material.DOUBLE_STEP.getNewData(i)));
            }
            for (i = 0; i < 16; i = (byte)(i + 1)) {
                cfg.set("35." + i, (Object)MaterialName.toReadable(Material.WOOL.getNewData(i)));
                cfg.set("351." + i, (Object)MaterialName.toReadable(Material.INK_SACK.getNewData(i)));
            }
            try {
                cfg.save(file);
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Unable to save material.yml: ", ex);
            }
        }
        for (String entry : cfg.getKeys(false)) {
            if (Utils.isInt(entry)) {
                if (cfg.isString(entry)) {
                    materialNames.put(Integer.valueOf(entry), cfg.getString(entry));
                    continue;
                }
                if (cfg.isConfigurationSection(entry)) {
                    HashMap<Byte, String> dataNames = new HashMap<Byte, String>();
                    materialDataNames.put(Integer.valueOf(entry), dataNames);
                    ConfigurationSection sec = cfg.getConfigurationSection(entry);
                    for (String data : sec.getKeys(false)) {
                        if (Utils.isByte(data)) {
                            if (sec.isString(data)) {
                                dataNames.put(Byte.valueOf(data), sec.getString(data));
                                continue;
                            }
                            Bukkit.getLogger().warning("Parsing materials.yml: '" + data + "' is not a string.");
                            continue;
                        }
                        Bukkit.getLogger().warning("Parsing materials.yml: '" + data + "' is no valid material data");
                    }
                    continue;
                }
                Bukkit.getLogger().warning("Parsing materials.yml: '" + entry + "' is neither a string nor a section.");
                continue;
            }
            Bukkit.getLogger().warning("Parsing materials.yml: '" + entry + "' is no valid material id");
        }
    }
}

