/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import java.io.Closeable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MySQLConnectionPool
implements Closeable {
    private static final int poolsize = 10;
    private static final long timeToLive = 300000L;
    private final Vector<JDCConnection> connections;
    private final ConnectionReaper reaper;
    private final String url;
    private final String user;
    private final String password;
    private final Lock lock = new ReentrantLock();

    public MySQLConnectionPool(String url, String user, String password) throws ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        this.url = url;
        this.user = user;
        this.password = password;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper();
        this.reaper.start();
    }

    @Override
    public void close() {
        this.lock.lock();
        Enumeration<JDCConnection> conns = this.connections.elements();
        while (conns.hasMoreElements()) {
            JDCConnection conn = conns.nextElement();
            this.connections.remove(conn);
            conn.terminate();
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        this.lock.lock();
        try {
            JDCConnection conn;
            Enumeration<JDCConnection> conns = this.connections.elements();
            while (conns.hasMoreElements()) {
                conn = conns.nextElement();
                if (!conn.lease()) continue;
                if (conn.isValid()) {
                    JDCConnection jDCConnection = conn;
                    return jDCConnection;
                }
                this.connections.remove(conn);
                conn.terminate();
            }
            conn = new JDCConnection(DriverManager.getConnection(this.url, this.user, this.password));
            conn.lease();
            if (!conn.isValid()) {
                conn.terminate();
                throw new SQLException("Failed to validate a brand new connection");
            }
            this.connections.add(conn);
            JDCConnection jDCConnection = conn;
            return jDCConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reapConnections() {
        this.lock.lock();
        long stale = System.currentTimeMillis() - 300000L;
        Iterator<JDCConnection> itr = this.connections.iterator();
        while (itr.hasNext()) {
            JDCConnection conn = itr.next();
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.isValid()) continue;
            itr.remove();
        }
        this.lock.unlock();
    }

    private class JDCConnection
    implements Connection {
        private final Connection conn;
        private boolean inuse;
        private long timestamp;
        private int networkTimeout;
        private String schema;

        JDCConnection(Connection conn) {
            this.conn = conn;
            this.inuse = false;
            this.timestamp = 0L;
            this.networkTimeout = 30;
            this.schema = "default";
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.conn.clearWarnings();
        }

        @Override
        public void close() {
            this.inuse = false;
            try {
                if (!this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                MySQLConnectionPool.this.connections.remove(this.conn);
                this.terminate();
            }
        }

        @Override
        public void commit() throws SQLException {
            this.conn.commit();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.conn.createArrayOf(typeName, elements);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.conn.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.conn.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.conn.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.conn.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.conn.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.conn.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.conn.createStruct(typeName, attributes);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.conn.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.conn.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.conn.getClientInfo();
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.conn.getClientInfo(name);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.conn.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.conn.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.conn.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.conn.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.conn.getWarnings();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.conn.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.conn.isReadOnly();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.conn.isValid(timeout);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.conn.isWrapperFor(iface);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.conn.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.conn.prepareCall(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.conn.prepareStatement(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.conn.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.conn.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.conn.prepareStatement(sql, columnNames);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.conn.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.conn.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.conn.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.conn.setAutoCommit(autoCommit);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.conn.setCatalog(catalog);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.conn.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.conn.setClientInfo(name, value);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.conn.setHoldability(holdability);
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.conn.setReadOnly(readOnly);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.conn.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.conn.setSavepoint(name);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.conn.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.conn.setTypeMap(map);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.conn.unwrap(iface);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.networkTimeout;
        }

        @Override
        public void setNetworkTimeout(Executor exec, int timeout) throws SQLException {
            this.networkTimeout = timeout;
        }

        @Override
        public void abort(Executor exec) throws SQLException {
        }

        @Override
        public String getSchema() throws SQLException {
            return this.schema;
        }

        @Override
        public void setSchema(String str) throws SQLException {
            this.schema = str;
        }

        long getLastUse() {
            return this.timestamp;
        }

        boolean inUse() {
            return this.inuse;
        }

        boolean isValid() {
            try {
                return this.conn.isValid(1);
            }
            catch (SQLException ex) {
                return false;
            }
        }

        synchronized boolean lease() {
            if (this.inuse) {
                return false;
            }
            this.inuse = true;
            this.timestamp = System.currentTimeMillis();
            return true;
        }

        void terminate() {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class ConnectionReaper
    extends Thread {
        private ConnectionReaper() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MySQLConnectionPool.this.reapConnections();
            }
        }
    }
}

