/*
 * Decompiled with CFR 0.152.
 */
package com.drdanick.McRKit;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class PropertiesFile {
    private Properties properties;
    private String fileName;

    public PropertiesFile(Properties properties) {
        this.properties = properties;
        this.fileName = null;
    }

    public void load() {
        try {
            this.properties.load(new FileInputStream(this.fileName));
        }
        catch (IOException iOException) {
            System.err.println("Unnable to load " + this.fileName + ": " + iOException.toString());
        }
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.fileName), "Minecraft Remote Toolkit Properties File");
        }
        catch (IOException iOException) {
            System.err.println("Unnable to save " + this.fileName + ": " + iOException.toString());
        }
    }

    public boolean keyExists(String string) {
        return this.properties.containsKey(string);
    }

    public String getString(String string) {
        return this.properties.getProperty(string);
    }

    public String getString(String string, String string2) {
        if (this.properties.containsKey(string)) {
            return this.properties.getProperty(string);
        }
        this.setString(string, string2);
        return string2;
    }

    public void setString(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public int getInt(String string) {
        return Integer.parseInt(this.properties.getProperty(string));
    }

    public int getInt(String string, int n) {
        if (this.properties.containsKey(string)) {
            return Integer.parseInt(this.properties.getProperty(string));
        }
        this.setInt(string, n);
        return n;
    }

    public void setInt(String string, int n) {
        this.properties.setProperty(string, String.valueOf(n));
    }

    public long getLong(String string) {
        return Long.parseLong(this.properties.getProperty(string));
    }

    public long getLong(String string, long l) {
        if (this.properties.containsKey(string)) {
            return Long.parseLong(this.properties.getProperty(string));
        }
        this.setLong(string, l);
        return l;
    }

    public void setLong(String string, long l) {
        this.properties.setProperty(string, String.valueOf(l));
    }

    public boolean getBoolean(String string) {
        return Boolean.parseBoolean(this.properties.getProperty(string));
    }

    public boolean getBoolean(String string, boolean bl) {
        if (this.properties.containsKey(string)) {
            return Boolean.parseBoolean(this.properties.getProperty(string));
        }
        this.setBoolean(string, bl);
        return bl;
    }

    public void setBoolean(String string, boolean bl) {
        this.properties.setProperty(string, String.valueOf(bl));
    }

    public Properties getProperties() {
        return this.properties;
    }
}

