/*
 * Decompiled with CFR 0.152.
 */
package com.drdanick.McRKit.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitTask;

public class BukkitMetricsLite {
    private static final int REVISION = 6;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final int PING_INTERVAL = 10;
    private final Plugin plugin;
    private final YamlConfiguration configuration;
    private final File configurationFile;
    private final String guid;
    private final boolean debug;
    private final Object optOutLock = new Object();
    private volatile BukkitTask task = null;

    public BukkitMetricsLite(Plugin plugin) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.configurationFile = this.getConfigFile();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        this.configuration.addDefault("debug", (Object)false);
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header(BASE_URL).copyDefaults(true);
            this.configuration.save(this.configurationFile);
        }
        this.guid = this.configuration.getString("guid");
        this.debug = this.configuration.getBoolean("debug", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                return false;
            }
            if (this.task != null) {
                return true;
            }
            this.task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, new Runnable(){
                private boolean firstPost = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block6: {
                        try {
                            Object object = BukkitMetricsLite.this.optOutLock;
                            synchronized (object) {
                                if (BukkitMetricsLite.this.isOptOut() && BukkitMetricsLite.this.task != null) {
                                    BukkitMetricsLite.this.task.cancel();
                                    BukkitMetricsLite.this.task = null;
                                }
                            }
                            BukkitMetricsLite.this.postPlugin(!this.firstPost);
                            this.firstPost = false;
                        }
                        catch (IOException iOException) {
                            if (!BukkitMetricsLite.this.debug) break block6;
                            Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                        }
                    }
                }
            }, 0L, 12000L);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            try {
                this.configuration.load(this.getConfigFile());
            }
            catch (IOException iOException) {
                if (this.debug) {
                    Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                }
                return true;
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                if (this.debug) {
                    Bukkit.getLogger().log(Level.INFO, "[Metrics] " + invalidConfigurationException.getMessage());
                }
                return true;
            }
            return this.configuration.getBoolean("opt-out", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                this.configuration.set("opt-out", (Object)false);
                this.configuration.save(this.configurationFile);
            }
            if (this.task == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (!this.isOptOut()) {
                this.configuration.set("opt-out", (Object)true);
                this.configuration.save(this.configurationFile);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    public File getConfigFile() {
        File file = this.plugin.getDataFolder().getParentFile();
        return new File(new File(file, "PluginMetrics"), "config.yml");
    }

    private void postPlugin(boolean bl) throws IOException {
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        String string = "RemoteToolkit";
        boolean bl2 = Bukkit.getServer().getOnlineMode();
        String string2 = pluginDescriptionFile.getVersion();
        String string3 = Bukkit.getVersion();
        int n = Bukkit.getServer().getOnlinePlayers().length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BukkitMetricsLite.encode("guid")).append('=').append(BukkitMetricsLite.encode(this.guid));
        BukkitMetricsLite.encodeDataPair(stringBuilder, "version", string2);
        BukkitMetricsLite.encodeDataPair(stringBuilder, "server", string3);
        BukkitMetricsLite.encodeDataPair(stringBuilder, "players", Integer.toString(n));
        BukkitMetricsLite.encodeDataPair(stringBuilder, "revision", String.valueOf(6));
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        String string6 = System.getProperty("os.version");
        String string7 = System.getProperty("java.version");
        int n2 = Runtime.getRuntime().availableProcessors();
        if (string5.equals("amd64")) {
            string5 = "x86_64";
        }
        BukkitMetricsLite.encodeDataPair(stringBuilder, "osname", string4);
        BukkitMetricsLite.encodeDataPair(stringBuilder, "osarch", string5);
        BukkitMetricsLite.encodeDataPair(stringBuilder, "osversion", string6);
        BukkitMetricsLite.encodeDataPair(stringBuilder, "cores", Integer.toString(n2));
        BukkitMetricsLite.encodeDataPair(stringBuilder, "online-mode", Boolean.toString(bl2));
        BukkitMetricsLite.encodeDataPair(stringBuilder, "java_version", string7);
        if (bl) {
            BukkitMetricsLite.encodeDataPair(stringBuilder, "ping", "true");
        }
        URL uRL = new URL(BASE_URL + String.format(REPORT_URL, BukkitMetricsLite.encode(string)));
        URLConnection uRLConnection = this.isMineshafterPresent() ? uRL.openConnection(Proxy.NO_PROXY) : uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(stringBuilder.toString());
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string8 = bufferedReader.readLine();
        outputStreamWriter.close();
        bufferedReader.close();
        if (string8 == null || string8.startsWith("ERR")) {
            throw new IOException(string8);
        }
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void encodeDataPair(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        stringBuilder.append('&').append(BukkitMetricsLite.encode(string)).append('=').append(BukkitMetricsLite.encode(string2));
    }

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }
}

