/*
 * Decompiled with CFR 0.152.
 */
package com.drdanick.McRKit.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class BukkitMetricsLiteLegacy {
    private static final int REVISION = 5;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final String CONFIG_FILE = "plugins/PluginMetrics/config.yml";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final int PING_INTERVAL = 10;
    private final Plugin plugin;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Graph defaultGraph = new Graph("Default");
    private final YamlConfiguration configuration;
    private final File configurationFile;
    private final String guid;
    private final Object optOutLock = new Object();
    private volatile int taskId = -1;

    public BukkitMetricsLiteLegacy(Plugin plugin) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.configurationFile = new File(CONFIG_FILE);
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header(BASE_URL).copyDefaults(true);
            this.configuration.save(this.configurationFile);
        }
        this.guid = this.configuration.getString("guid");
    }

    public Graph createGraph(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(string);
        this.graphs.add(graph);
        return graph;
    }

    public void addCustomData(Plotter plotter) {
        if (plotter == null) {
            throw new IllegalArgumentException("Plotter cannot be null");
        }
        this.defaultGraph.addPlotter(plotter);
        this.graphs.add(this.defaultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                return false;
            }
            if (this.taskId >= 0) {
                return true;
            }
            this.taskId = this.plugin.getServer().getScheduler().scheduleAsyncRepeatingTask(this.plugin, new Runnable(){
                private boolean firstPost = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = BukkitMetricsLiteLegacy.this.optOutLock;
                        synchronized (object) {
                            if (BukkitMetricsLiteLegacy.this.isOptOut() && BukkitMetricsLiteLegacy.this.taskId > 0) {
                                BukkitMetricsLiteLegacy.this.plugin.getServer().getScheduler().cancelTask(BukkitMetricsLiteLegacy.this.taskId);
                                BukkitMetricsLiteLegacy.this.taskId = -1;
                            }
                        }
                        BukkitMetricsLiteLegacy.this.postPlugin(!this.firstPost);
                        this.firstPost = false;
                    }
                    catch (IOException iOException) {
                        Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                    }
                }
            }, 0L, 12000L);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            try {
                this.configuration.load(CONFIG_FILE);
            }
            catch (IOException iOException) {
                Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                return true;
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                Bukkit.getLogger().log(Level.INFO, "[Metrics] " + invalidConfigurationException.getMessage());
                return true;
            }
            return this.configuration.getBoolean("opt-out", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                this.configuration.set("opt-out", (Object)false);
                this.configuration.save(this.configurationFile);
            }
            if (this.taskId < 0) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (!this.isOptOut()) {
                this.configuration.set("opt-out", (Object)true);
                this.configuration.save(this.configurationFile);
            }
            if (this.taskId > 0) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskId);
                this.taskId = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean bl) throws IOException {
        Object object;
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BukkitMetricsLiteLegacy.encode("guid")).append('=').append(BukkitMetricsLiteLegacy.encode(this.guid));
        BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, "version", pluginDescriptionFile.getVersion());
        BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, "server", Bukkit.getVersion());
        BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, "players", Integer.toString(Bukkit.getServer().getOnlinePlayers().length));
        BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, "revision", String.valueOf(5));
        if (bl) {
            BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, "ping", "true");
        }
        Object object4 = this.graphs;
        synchronized (object4) {
            for (Graph object32 : this.graphs) {
                for (Plotter plotter : object32.getPlotters()) {
                    object = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, object32.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String string = Integer.toString(plotter.getValue());
                    BukkitMetricsLiteLegacy.encodeDataPair(stringBuilder, (String)object, string);
                }
            }
        }
        object4 = new URL(BASE_URL + String.format(REPORT_URL, BukkitMetricsLiteLegacy.encode("RemoteToolkit")));
        URLConnection uRLConnection = this.isMineshafterPresent() ? ((URL)object4).openConnection(Proxy.NO_PROXY) : ((URL)object4).openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(stringBuilder.toString());
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string = bufferedReader.readLine();
        outputStreamWriter.close();
        bufferedReader.close();
        if (string == null || string.startsWith("ERR")) {
            throw new IOException(string);
        }
        if (string.contains("OK This is your first update this hour")) {
            object = this.graphs;
            synchronized (object) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void encodeDataPair(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        stringBuilder.append('&').append(BukkitMetricsLiteLegacy.encode(string)).append('=').append(BukkitMetricsLiteLegacy.encode(string2));
    }

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String string) {
            this.name = string;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode() + this.getValue();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }
    }
}

