/*
 * Decompiled with CFR 0.152.
 */
package com.drdanick.McRKit.plugin;

import com.drdanick.McRKit.plugin.BukkitMetricsLite;
import com.drdanick.McRKit.plugin.BukkitMetricsLiteLegacy;
import com.drdanick.McRKit.plugin.LegacySupport;
import com.drdanick.McRKit.plugin.RTKEventHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.libs.jline.Terminal;
import org.bukkit.craftbukkit.libs.jline.TerminalSupport;
import org.bukkit.craftbukkit.libs.jline.UnsupportedTerminal;
import org.bukkit.craftbukkit.libs.jline.console.ConsoleReader;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RTKPlugin
extends JavaPlugin {
    public String version;
    public static final Logger log = Logger.getLogger("Minecraft");
    private Properties properties;
    private Map<String, String> messageMap;
    private RTKEventHandler eventHandler;

    public void onEnable() {
        try {
            BukkitMetricsLite bukkitMetricsLite = new BukkitMetricsLite((Plugin)this);
            bukkitMetricsLite.start();
        }
        catch (Throwable throwable) {
            try {
                new BukkitMetricsLiteLegacy((Plugin)this).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.version = this.getDescription().getVersion();
            this.properties = this.loadProperties(new FileInputStream("toolkit/remote.properties"));
            this.messageMap = RTKPlugin.loadMap(new FileInputStream("toolkit/messages.txt"));
        }
        catch (IOException iOException) {
            log.info("Error loading Toolkit plugin properties: " + iOException);
            iOException.printStackTrace();
        }
        this.eventHandler = new RTKEventHandler(this, this.properties);
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().maxMemory();
        System.out.println("Memory max: " + l2 + " bytes");
        System.out.println("Memory total: " + l + " bytes");
        try {
            Terminal terminal;
            Server server = this.getServer();
            Method method = server.getClass().getMethod("getReader", new Class[0]);
            Object object = method.invoke((Object)server, new Object[0]);
            if (object instanceof ConsoleReader && (terminal = ((ConsoleReader)object).getTerminal()) instanceof UnsupportedTerminal) {
                Method method2 = TerminalSupport.class.getDeclaredMethod("setAnsiSupported", Boolean.TYPE);
                method2.setAccessible(true);
                method2.invoke((Object)terminal, true);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                LegacySupport.initMetrics(this);
            }
            catch (Throwable throwable) {
                System.err.println("ERROR LOADING TOOLKIT PLUGIN: " + throwable);
                throwable.printStackTrace();
            }
        }
        catch (Exception exception) {
            try {
                LegacySupport.initMetrics(this);
            }
            catch (Throwable throwable) {
                System.err.println("ERROR LOADING TOOLKIT PLUGIN: " + throwable);
                throwable.printStackTrace();
            }
        }
        log.info("Remote Toolkit Plugin " + this.version + " enabled!");
    }

    public void onDisable() {
        log.info("Remote Toolkit Plugin " + this.version + " disabled!");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, String> getMessageMap() {
        return this.messageMap;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        return this.eventHandler.onCommand(commandSender, command, string, stringArray, this);
    }

    private Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadMap(InputStream inputStream) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Scanner scanner = null;
        try {
            scanner = new Scanner(inputStream);
            while (scanner.hasNextLine()) {
                String[] stringArray = scanner.nextLine().trim().split(":");
                String string = stringArray[0];
                String string2 = "";
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = string2 + ":" + stringArray[i];
                }
                if (string2.length() > 0) {
                    hashMap.put(string, string2.substring(1));
                    continue;
                }
                hashMap.put(string, "");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            scanner.close();
        }
        return hashMap;
    }
}

