/*
 * Decompiled with CFR 0.152.
 */
package ca.xshade.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileMgmt {
    public static void checkFolders(String[] folders) {
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            File f = new File(folder);
            if (!f.exists() || !f.isDirectory()) {
                f.mkdir();
            }
            ++n2;
        }
    }

    public static void checkFiles(String[] files) throws IOException {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File f = new File(file);
            if (!f.exists() || !f.isFile()) {
                f.createNewFile();
            }
            ++n2;
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                FileMgmt.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void zipDirectory(File sourceFolder, File destination) throws IOException {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destination));
        FileMgmt.recursiveZipDirectory(sourceFolder, output);
        output.close();
    }

    public static void zipDirectories(File[] sourceFolders, File destination) throws IOException {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destination));
        File[] fileArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceFolder = fileArray[n2];
            FileMgmt.recursiveZipDirectory(sourceFolder, output);
            ++n2;
        }
        output.close();
    }

    public static void recursiveZipDirectory(File sourceFolder, ZipOutputStream zipStream) throws IOException {
        String[] dirList = sourceFolder.list();
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        int i = 0;
        while (i < dirList.length) {
            File f = new File(sourceFolder, dirList[i]);
            if (f.isDirectory()) {
                FileMgmt.recursiveZipDirectory(f, zipStream);
            } else {
                FileInputStream input = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zipStream.putNextEntry(anEntry);
                while ((bytesIn = input.read(readBuffer)) != -1) {
                    zipStream.write(readBuffer, 0, bytesIn);
                }
                input.close();
            }
            ++i;
        }
    }
}

