/*
 * Decompiled with CFR 0.152.
 */
package ca.xshade.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class PropertiesFile {
    private static final Logger log = Logger.getLogger("Minecraft");
    private String fileName;
    private Properties props = new Properties();

    public PropertiesFile(String fileName) {
        this.fileName = fileName;
        File file = new File(fileName);
        try {
            if (file.exists()) {
                this.load();
            } else {
                this.save();
            }
        }
        catch (IOException ex) {
            log.severe("[PropertiesFile] Unable to load " + fileName + "!");
        }
    }

    public void load() throws IOException {
        this.props.load(new FileInputStream(this.fileName));
    }

    public void save() {
        try {
            this.props.store(new FileOutputStream(this.fileName), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Map<String, String> returnMap() throws Exception {
        return (Map)this.props.clone();
    }

    public boolean containsKey(String var) {
        return this.props.containsKey(var);
    }

    public String getProperty(String var) {
        return this.props.getProperty(var);
    }

    public void removeKey(String var) {
        if (this.props.containsKey(var)) {
            this.props.remove(var);
            this.save();
        }
    }

    public boolean keyExists(String key) {
        return this.containsKey(key);
    }

    public String getString(String key) {
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        return "";
    }

    public String getString(String key, String value) {
        if (this.containsKey(key)) {
            return this.getProperty(key);
        }
        this.setString(key, value);
        return value;
    }

    public void setString(String key, String value) {
        this.props.put(key, value);
        this.save();
    }

    public int getInt(String key) {
        if (this.containsKey(key)) {
            return Integer.parseInt(this.getProperty(key));
        }
        return 0;
    }

    public int getInt(String key, int value) {
        if (this.containsKey(key)) {
            return Integer.parseInt(this.getProperty(key));
        }
        this.setInt(key, value);
        return value;
    }

    public void setInt(String key, int value) {
        this.props.put(key, String.valueOf(value));
        this.save();
    }

    public double getDouble(String key) {
        if (this.containsKey(key)) {
            return Double.parseDouble(this.getProperty(key));
        }
        return 0.0;
    }

    public double getDouble(String key, double value) {
        if (this.containsKey(key)) {
            return Double.parseDouble(this.getProperty(key));
        }
        this.setDouble(key, value);
        return value;
    }

    public void setDouble(String key, double value) {
        this.props.put(key, String.valueOf(value));
        this.save();
    }

    public long getLong(String key) {
        if (this.containsKey(key)) {
            return Long.parseLong(this.getProperty(key));
        }
        return 0L;
    }

    public long getLong(String key, long value) {
        if (this.containsKey(key)) {
            return Long.parseLong(this.getProperty(key));
        }
        this.setLong(key, value);
        return value;
    }

    public void setLong(String key, long value) {
        this.props.put(key, String.valueOf(value));
        this.save();
    }

    public boolean getBoolean(String key) {
        if (this.containsKey(key)) {
            return Boolean.parseBoolean(this.getProperty(key));
        }
        return false;
    }

    public boolean getBoolean(String key, boolean value) {
        if (this.containsKey(key)) {
            return Boolean.parseBoolean(this.getProperty(key));
        }
        this.setBoolean(key, value);
        return value;
    }

    public void setBoolean(String key, boolean value) {
        this.props.put(key, String.valueOf(value));
        this.save();
    }
}

