/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat;

import com.ensifera.animosity.craftirc.CraftIRC;
import com.palmergames.bukkit.TownyChat.Command.ChannelCommand;
import com.palmergames.bukkit.TownyChat.Command.JoinCommand;
import com.palmergames.bukkit.TownyChat.Command.LeaveCommand;
import com.palmergames.bukkit.TownyChat.Command.MuteCommand;
import com.palmergames.bukkit.TownyChat.Command.MuteListCommand;
import com.palmergames.bukkit.TownyChat.Command.TownyChatCommand;
import com.palmergames.bukkit.TownyChat.Command.UnmuteCommand;
import com.palmergames.bukkit.TownyChat.CraftIRCHandler;
import com.palmergames.bukkit.TownyChat.channels.ChannelsHolder;
import com.palmergames.bukkit.TownyChat.config.ConfigurationHandler;
import com.palmergames.bukkit.TownyChat.listener.HeroicDeathForwarder;
import com.palmergames.bukkit.TownyChat.listener.TownyChatPlayerListener;
import com.palmergames.bukkit.TownyChat.tasks.onLoadedTask;
import com.palmergames.bukkit.TownyChat.util.FileMgmt;
import com.palmergames.bukkit.towny.Towny;
import java.util.HashMap;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.dynmap.DynmapAPI;

public class Chat
extends JavaPlugin {
    private TownyChatPlayerListener TownyPlayerListener;
    private ChannelsHolder channels;
    private ConfigurationHandler configuration;
    protected PluginManager pm;
    private Towny towny = null;
    private CraftIRC craftIRC = null;
    private DynmapAPI dynMap = null;
    private CraftIRCHandler irc = null;
    private HeroicDeathForwarder heroicDeathListener = null;

    public void onEnable() {
        this.pm = this.getServer().getPluginManager();
        this.configuration = new ConfigurationHandler(this);
        this.channels = new ChannelsHolder(this);
        this.checkPlugins();
        if (this.towny == null || this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new onLoadedTask(this), 1L) == -1 || !this.load()) {
            this.getLogger().severe("Could not schedule onLoadedTask.");
            this.getLogger().severe("disabling TownyChat");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        this.getCommand("townychat").setExecutor((CommandExecutor)new TownyChatCommand(this));
        this.getCommand("channel").setExecutor((CommandExecutor)new ChannelCommand(this));
        this.getCommand("join").setExecutor((CommandExecutor)new JoinCommand(this));
        this.getCommand("leave").setExecutor((CommandExecutor)new LeaveCommand(this));
        this.getCommand("chmute").setExecutor((CommandExecutor)new MuteCommand(this));
        this.getCommand("chunmute").setExecutor((CommandExecutor)new UnmuteCommand(this));
        this.getCommand("mutelist").setExecutor((CommandExecutor)new MuteListCommand(this));
    }

    private boolean load() {
        FileMgmt.checkFolders(new String[]{this.getRootPath(), this.getChannelsPath()});
        return this.configuration.loadChannels(this.getChannelsPath(), "Channels.yml");
    }

    public void onDisable() {
        this.unregisterPermissions();
        if (this.craftIRC != null) {
            this.craftIRC.unregisterEndPoint("towny");
            this.craftIRC = null;
        }
        this.irc = null;
        this.dynMap = null;
        this.heroicDeathListener = null;
        this.towny = null;
        this.pm = null;
        this.configuration = null;
        this.channels = null;
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    private void checkPlugins() {
        Plugin test = this.pm.getPlugin("Towny");
        if (test != null && test instanceof Towny) {
            this.towny = (Towny)test;
        }
        if ((test = this.pm.getPlugin("CraftIRC")) != null) {
            this.craftIRC = (CraftIRC)test;
            this.irc = new CraftIRCHandler(this, this.craftIRC, "towny");
        }
        if (this.irc != null && (test = this.pm.getPlugin("HeroicDeath")) != null) {
            this.heroicDeathListener = new HeroicDeathForwarder(this.irc);
            this.getLogger().info("[TownyChat] Found and attempting to relay Heroic Death messages to craftIRC.");
        }
        if ((test = this.pm.getPlugin("dynmap")) != null) {
            this.dynMap = (DynmapAPI)test;
        }
    }

    public void registerEvents() {
        if (this.TownyPlayerListener == null) {
            this.TownyPlayerListener = new TownyChatPlayerListener(this);
            if (this.TownyPlayerListener != null) {
                this.pm.registerEvents((Listener)this.TownyPlayerListener, (Plugin)this);
            }
            if (this.heroicDeathListener != null) {
                this.pm.registerEvents((Listener)this.heroicDeathListener, (Plugin)this);
            }
        }
    }

    public void registerPermissions() {
        for (String perm : this.getChannelsHandler().getAllPermissions()) {
            try {
                this.pm.addPermission(new Permission(perm, new HashMap()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void unregisterPermissions() {
        for (String perm : this.getChannelsHandler().getAllPermissions()) {
            this.pm.removePermission(new Permission(perm, new HashMap()));
        }
    }

    public String getRootPath() {
        return this.getTowny().getDataFolder().getPath();
    }

    public String getChannelsPath() {
        return this.getRootPath() + FileMgmt.fileSeparator() + "settings";
    }

    public ChannelsHolder getChannelsHandler() {
        return this.channels;
    }

    public ConfigurationHandler getConfigurationHandler() {
        return this.configuration;
    }

    public Towny getTowny() {
        return this.towny;
    }

    public CraftIRCHandler getIRC() {
        return this.irc;
    }

    public DynmapAPI getDynmap() {
        return this.dynMap;
    }

    public HeroicDeathForwarder getHeroicDeath() {
        return this.heroicDeathListener;
    }
}

