/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat;

import com.palmergames.bukkit.TownyChat.TownyChatReplacerCallable;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.TownyChat.util.StringReplaceManager;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.regex.Pattern;

public class TownyChatFormatter {
    private static StringReplaceManager<LocalTownyChatEvent> replacer = new StringReplaceManager();

    public static String getChatFormat(LocalTownyChatEvent event) {
        return replacer.replaceAll(event.getFormat(), event).replace("{modplayername}", "%1$s").replace("{msg}", "%2$s");
    }

    public static String formatTownyTag(Resident resident, Boolean override, Boolean full) {
        try {
            if (resident.hasTown()) {
                Town town = resident.getTown();
                String townTag = town.getTag();
                Nation nation = null;
                String nationTag = null;
                if (resident.hasNation()) {
                    nation = town.getNation();
                    nationTag = nation.getTag();
                }
                String nTag = "";
                String tTag = "";
                if (full.booleanValue()) {
                    nationTag = "";
                    townTag = "";
                }
                if (townTag != null && !townTag.isEmpty()) {
                    tTag = townTag;
                } else if (override.booleanValue() || full.booleanValue()) {
                    tTag = town.getName();
                }
                if (nationTag != null && !nationTag.isEmpty()) {
                    nTag = nationTag;
                } else if (resident.hasNation() && (override.booleanValue() || full.booleanValue())) {
                    nTag = nation.getName();
                }
                if (!tTag.isEmpty() && !nTag.isEmpty()) {
                    return String.format(ChatSettings.getBothTags(), nTag, tTag);
                }
                if (!nTag.isEmpty()) {
                    return String.format(ChatSettings.getNationTag(), nTag);
                }
                if (!tTag.isEmpty()) {
                    return String.format(ChatSettings.getTownTag(), tTag);
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    public static String formatTownTag(Resident resident, Boolean override, Boolean full) {
        try {
            if (resident.hasTown()) {
                if (full.booleanValue()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getName());
                }
                if (resident.getTown().hasTag()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getTag());
                }
                if (override.booleanValue()) {
                    return String.format(ChatSettings.getTownTag(), resident.getTown().getName());
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    public static String formatNationTag(Resident resident, Boolean override, Boolean full) {
        try {
            if (resident.hasNation()) {
                if (full.booleanValue()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getName());
                }
                if (resident.getTown().getNation().hasTag()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getTag());
                }
                if (override.booleanValue()) {
                    return String.format(ChatSettings.getNationTag(), resident.getTown().getNation().getName());
                }
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return "";
    }

    static {
        replacer.registerFormatReplacement(Pattern.quote("{worldname}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return String.format(ChatSettings.getWorldTag(), event.getEvent().getPlayer().getWorld().getName());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{town}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasTown() ? event.getResident().getTown().getName() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownTag(event.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{towntag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownTag(event.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{towntagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownTag(event.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nation}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasNation() ? event.getResident().getTown().getNation().getName() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatNationTag(event.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationtag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatNationTag(event.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{nationtagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatNationTag(event.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townytag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownyTag(event.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townyformatted}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownyTag(event.getResident(), false, true);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townytagoverride}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownyTag(event.getResident(), true, false);
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{title}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasTitle() ? event.getResident().getTitle() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{surname}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasSurname() ? event.getResident().getSurname() : "";
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townynameprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyFormatter.getNamePrefix((Resident)event.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townynamepostfix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyFormatter.getNamePostfix((Resident)event.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townyprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasTitle() ? event.getResident().getTitle() : TownyFormatter.getNamePrefix((Resident)event.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townypostfix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().hasSurname() ? event.getResident().getSurname() : TownyFormatter.getNamePostfix((Resident)event.getResident());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{townycolor}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getResident().isMayor() ? (event.getResident().isKing() ? ChatSettings.getKingColour() : ChatSettings.getMayorColour()) : ChatSettings.getResidentColour();
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{group}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyUniverse.getPermissionSource().getPlayerGroup(event.getEvent().getPlayer());
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{permprefix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyUniverse.getPermissionSource().getPrefixSuffix(event.getResident(), "prefix");
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{permsuffix}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyUniverse.getPermissionSource().getPrefixSuffix(event.getResident(), "suffix");
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{playername}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return event.getEvent().getPlayer().getName();
            }
        });
        replacer.registerFormatReplacement(Pattern.quote("{channelTag}"), new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return TownyChatFormatter.formatTownyTag(event.getResident(), false, false);
            }
        });
        replacer.registerFormatReplacement("&{1}[0-9A-Fa-f]{1}", new TownyChatReplacerCallable(){

            @Override
            public String call(String match, LocalTownyChatEvent event) throws Exception {
                return "\u00a7" + match.charAt(1);
            }
        });
    }
}

