/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.channels;

import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public abstract class Channel {
    private String name;
    private List<String> commands;
    private channelTypes type;
    private String channelTag;
    private String messageColour;
    private String permission;
    private String leavePermission;
    private String craftIRCTag;
    private double range;
    private boolean hooked = false;
    private boolean autojoin = true;
    protected ConcurrentMap<String, Integer> absentPlayers = null;
    protected ConcurrentMap<String, Integer> mutedPlayers = null;

    public Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public channelTypes getType() {
        return this.type;
    }

    public void setType(channelTypes type) {
        this.type = type;
    }

    public String getChannelTag() {
        return this.channelTag;
    }

    public void setChannelTag(String channelTag) {
        this.channelTag = channelTag;
    }

    public String getMessageColour() {
        return this.messageColour;
    }

    public void setMessageColour(String messageColour) {
        this.messageColour = messageColour;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getCraftIRCTag() {
        if (this.craftIRCTag == null || this.craftIRCTag.isEmpty()) {
            return "admin";
        }
        return this.craftIRCTag;
    }

    public void setCraftIRCTag(String craftIRCTag) {
        this.craftIRCTag = craftIRCTag;
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public abstract void chatProcess(AsyncPlayerChatEvent var1);

    public void forgetPlayer(String name) {
        if (this.autojoin) {
            this.join(name);
        } else {
            this.leave(name);
        }
    }

    public boolean leave(String name) {
        Integer res;
        if (this.absentPlayers == null) {
            this.absentPlayers = new ConcurrentHashMap<String, Integer>();
        }
        return (res = this.absentPlayers.put(name, 1)) == null || res == 0;
    }

    public boolean join(String name) {
        if (this.absentPlayers == null) {
            return false;
        }
        Integer res = (Integer)this.absentPlayers.remove(name);
        return res != null && res == 1;
    }

    public boolean isPresent(String name) {
        if (this.absentPlayers == null) {
            return true;
        }
        return !this.absentPlayers.containsKey(name);
    }

    public boolean isAbsent(String name) {
        return !this.isPresent(name);
    }

    public boolean isMuted(String name) {
        if (this.mutedPlayers == null) {
            return false;
        }
        return this.mutedPlayers.containsKey(name);
    }

    public boolean mute(String name) {
        Integer i;
        if (this.mutedPlayers == null) {
            this.mutedPlayers = new ConcurrentHashMap<String, Integer>();
        }
        if ((i = (Integer)this.mutedPlayers.get(name)) != null) {
            return false;
        }
        this.mutedPlayers.put(name, 1);
        return true;
    }

    public boolean unmute(String name) {
        if (this.mutedPlayers == null) {
            return false;
        }
        Integer i = (Integer)this.mutedPlayers.get(name);
        if (i == null) {
            return false;
        }
        this.mutedPlayers.remove(name);
        return true;
    }

    public String getLeavePermission() {
        return this.leavePermission;
    }

    public void setLeavePermission(String permission) {
        this.leavePermission = permission;
    }

    public boolean hasMuteList() {
        return this.mutedPlayers != null && !this.mutedPlayers.isEmpty();
    }

    public Set<String> getMuteList() {
        return this.mutedPlayers.keySet();
    }

    public void setHooked(boolean hooked) {
        this.hooked = hooked;
    }

    public boolean isHooked() {
        return this.hooked;
    }

    public void setAutoJoin(boolean autojoin) {
        this.autojoin = autojoin;
    }

    public boolean isAutoJoin() {
        return this.autojoin;
    }
}

