/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.channels;

import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

public class ChannelsHolder {
    private Chat plugin;
    private Channel defaultChan = null;
    private Map<String, Channel> channels = new HashMap<String, Channel>();

    public ChannelsHolder(Chat plugin) {
        this.plugin = plugin;
    }

    public void setDefaultChannel(Channel channel) {
        this.defaultChan = channel;
    }

    public Channel getDefaultChannel() {
        return this.defaultChan;
    }

    public Map<String, Channel> getAllChannels() {
        return this.channels;
    }

    public void setChannels(HashMap<String, Channel> channels) {
        this.channels = channels;
    }

    public void addChannel(Channel chan) {
        if (this.isChannel(chan.getName())) {
            this.channels.remove(chan);
        }
        this.channels.put(chan.getName(), chan);
    }

    public boolean isChannel(String channelName) {
        return this.channels.containsKey(channelName.toLowerCase());
    }

    public Channel getChannel(String channelName) {
        return this.channels.get(channelName.toLowerCase());
    }

    public Channel getChannel(Player player, String command) {
        for (Channel channel : this.channels.values()) {
            if (!channel.getCommands().contains(command.toLowerCase()) || this.plugin.getTowny().isPermissions() && (!this.plugin.getTowny().isPermissions() || !TownyUniverse.getPermissionSource().has(player, channel.getPermission()) && !channel.getPermission().isEmpty())) continue;
            return channel;
        }
        return null;
    }

    public Channel getActiveChannel(Player player, channelTypes type) {
        Channel local = null;
        Channel global = null;
        Channel world = null;
        String name = player.getName();
        for (Channel channel : this.channels.values()) {
            if (!channel.isPresent(name) || !channel.getType().equals((Object)type) || this.plugin.getTowny().isPermissions() && (!this.plugin.getTowny().isPermissions() || !TownyUniverse.getPermissionSource().has(player, channel.getPermission()) && !channel.getPermission().isEmpty())) continue;
            if (channel.getRange() == -1.0) {
                global = channel;
                continue;
            }
            if (channel.getRange() == 0.0) {
                world = channel;
                continue;
            }
            local = channel;
        }
        if (global != null) {
            return global;
        }
        if (world != null) {
            return world;
        }
        if (local != null) {
            return local;
        }
        return null;
    }

    public Channel getChannel(Player player, channelTypes type) {
        Channel local = null;
        Channel global = null;
        Channel world = null;
        for (Channel channel : this.channels.values()) {
            if (!channel.getType().equals((Object)type) || this.plugin.getTowny().isPermissions() && (!this.plugin.getTowny().isPermissions() || !TownyUniverse.getPermissionSource().has(player, channel.getPermission()) && !channel.getPermission().isEmpty())) continue;
            if (channel.getRange() == -1.0) {
                global = channel;
                continue;
            }
            if (channel.getRange() == 0.0) {
                world = channel;
                continue;
            }
            local = channel;
        }
        if (global != null) {
            return global;
        }
        if (world != null) {
            return world;
        }
        if (local != null) {
            return local;
        }
        return null;
    }

    public Set<String> getAllPermissions() {
        HashSet<String> perms = new HashSet<String>();
        for (Channel channel : this.channels.values()) {
            if (perms.contains(channel.getPermission())) continue;
            perms.add(channel.getPermission());
        }
        return perms;
    }

    public String getMutePermission() {
        return "townychat.mod.mute";
    }

    public String getUnmutePermission() {
        return "townychat.mod.unmute";
    }
}

