/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.channels;

import com.earth2me.essentials.User;
import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.CraftIRCHandler;
import com.palmergames.bukkit.TownyChat.TownyChatFormatter;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.events.AsyncChatHookEvent;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.dynmap.DynmapAPI;

public class StandardChannel
extends Channel {
    private Chat plugin;

    public StandardChannel(Chat instance, String name) {
        super(name);
        this.plugin = instance;
    }

    @Override
    public void chatProcess(AsyncPlayerChatEvent event) {
        channelTypes exec = channelTypes.valueOf(this.getType().name());
        Player player = event.getPlayer();
        Set<Player> recipients = null;
        Resident resident = null;
        Town town = null;
        Nation nation = null;
        String Format = "";
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            nation = resident.getTown().getNation();
        }
        catch (NotRegisteredException e1) {
            // empty catch block
        }
        boolean notifyjoin = false;
        if (this.isAbsent(player.getName())) {
            this.join(player.getName());
            notifyjoin = true;
        }
        switch (exec) {
            case TOWN: {
                if (town == null) {
                    event.setCancelled(true);
                    return;
                }
                Format = ChatSettings.getRelevantFormatGroup(player).getTOWN();
                recipients = new HashSet<Player>(this.findRecipients(player, TownyUniverse.getOnlinePlayers((Town)town)));
                recipients = this.checkSpying(recipients);
                break;
            }
            case NATION: {
                if (nation == null) {
                    event.setCancelled(true);
                    return;
                }
                Format = ChatSettings.getRelevantFormatGroup(player).getNATION();
                recipients = new HashSet<Player>(this.findRecipients(player, TownyUniverse.getOnlinePlayers((Nation)nation)));
                recipients = this.checkSpying(recipients);
                break;
            }
            case DEFAULT: {
                Format = ChatSettings.getRelevantFormatGroup(player).getDEFAULT();
                recipients = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
                break;
            }
            case GLOBAL: {
                Format = ChatSettings.getRelevantFormatGroup(player).getGLOBAL();
                recipients = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
                break;
            }
            case PRIVATE: {
                Format = ChatSettings.getRelevantFormatGroup(player).getGLOBAL();
                recipients = new HashSet<Player>(this.findRecipients(player, new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()))));
            }
        }
        if (ChatSettings.isModify_chat()) {
            event.setFormat(Format.replace("{channelTag}", this.getChannelTag()).replace("{msgcolour}", this.getMessageColour()));
        } else {
            event.setFormat(event.getFormat().replace("{channelTag}", this.getChannelTag()).replace("{msgcolour}", this.getMessageColour()));
        }
        LocalTownyChatEvent chatEvent = new LocalTownyChatEvent(event, resident);
        event.setFormat(TownyChatFormatter.getChatFormat(chatEvent));
        event.getRecipients().clear();
        event.getRecipients().addAll(recipients);
        if (this.isHooked()) {
            AsyncChatHookEvent hookEvent = new AsyncChatHookEvent(event, this);
            Bukkit.getServer().getPluginManager().callEvent((Event)hookEvent);
            if (hookEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (hookEvent.isChanged()) {
                event.setMessage(hookEvent.getMessage());
                event.setFormat(hookEvent.getFormat());
                event.getRecipients().clear();
                event.getRecipients().addAll(hookEvent.getRecipients());
            }
        }
        if (notifyjoin) {
            TownyMessaging.sendMsg((Object)player, (String)("You join \u00a7f" + this.getName()));
        }
        String msg = event.getFormat().replace("%1$s", event.getPlayer().getDisplayName()).replace("%2$s", event.getMessage());
        switch (exec) {
            case TOWN: {
                break;
            }
            case NATION: {
                break;
            }
            case DEFAULT: {
                break;
            }
            case GLOBAL: 
            case PRIVATE: {
                DynmapAPI dynMap = this.plugin.getDynmap();
                if (dynMap == null) break;
                dynMap.postPlayerMessageToWeb(player, event.getMessage());
            }
        }
        CraftIRCHandler ircHander = this.plugin.getIRC();
        if (ircHander != null) {
            ircHander.IRCSender(msg, this.getCraftIRCTag());
        }
    }

    private boolean testDistance(Player player1, Player player2, double range) {
        if (range == -1.0) {
            return true;
        }
        if (range == 0.0) {
            return player1.getWorld().equals(player2.getWorld());
        }
        if (player1.getWorld().equals(player2.getWorld())) {
            return player1.getLocation().distance(player2.getLocation()) < range;
        }
        return false;
    }

    private Set<Player> findRecipients(Player sender, List<Player> list) {
        HashSet<Player> recipients = new HashSet<Player>();
        Boolean bEssentials = this.plugin.getTowny().isEssentials();
        String sendersName = sender.getName();
        for (Player test : list) {
            if (this.plugin.getTowny().isPermissions() && (!this.plugin.getTowny().isPermissions() || !TownyUniverse.getPermissionSource().has(test, this.getPermission())) || !this.testDistance(sender, test, this.getRange()) && !this.plugin.getTowny().hasPlayerMode(test, "spy")) continue;
            if (bEssentials.booleanValue()) {
                try {
                    User targetUser = this.plugin.getTowny().getEssentials().getUser((Object)test);
                    if (targetUser.isIgnoredPlayer(sendersName)) {
                        continue;
                    }
                }
                catch (TownyException e) {
                    // empty catch block
                }
            }
            if (this.absentPlayers != null && this.absentPlayers.containsKey(test.getName())) continue;
            recipients.add(test);
        }
        return recipients;
    }

    private Set<Player> checkSpying(Set<Player> recipients) {
        ArrayList<Player> allOnline = new ArrayList<Player>(Arrays.asList(BukkitTools.getOnlinePlayers()));
        for (Player test : allOnline) {
            if (!this.plugin.getTowny().hasPlayerMode(test, "spy") || recipients.contains(test)) continue;
            recipients.add(test);
        }
        return recipients;
    }
}

