/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.config;

import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.channels.StandardChannel;
import com.palmergames.bukkit.TownyChat.channels.channelFormats;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfigurationHandler {
    private Chat plugin;

    public ConfigurationHandler(Chat plugin) {
        this.plugin = plugin;
    }

    public boolean loadChannels(String filepath, String defaultRes) {
        String filename = filepath + FileMgmt.fileSeparator() + defaultRes;
        Map<String, Object> file = FileMgmt.getFile(filename, defaultRes, null);
        if (file != null) {
            for (String rootNode : file.keySet()) {
                Map allChannelNodes;
                if (!rootNode.equalsIgnoreCase("Channels") || (allChannelNodes = (Map)file.get(rootNode)) == null) continue;
                for (String channelKey : allChannelNodes.keySet()) {
                    if (channelKey.equalsIgnoreCase("spam_time")) {
                        ChatSettings.setSpam_time((Double)allChannelNodes.get(channelKey));
                    }
                    Map thisChannelNode = (Map)allChannelNodes.get(channelKey);
                    StandardChannel channel = new StandardChannel(this.plugin, channelKey.toLowerCase());
                    for (String key : thisChannelNode.keySet()) {
                        Object element = thisChannelNode.get(key);
                        if (key.equalsIgnoreCase("commands")) {
                            if (element instanceof ArrayList) {
                                channel.setCommands((List)element);
                            } else if (element instanceof String) {
                                channel.setCommands(Arrays.asList(element.toString()));
                            }
                        }
                        if (key.equalsIgnoreCase("type") && element instanceof String) {
                            channel.setType(channelTypes.valueOf(element.toString()));
                        }
                        if (key.equalsIgnoreCase("hooked")) {
                            if (element instanceof Boolean) {
                                channel.setHooked((Boolean)element);
                            } else if (element instanceof String) {
                                channel.setHooked(Boolean.parseBoolean(element.toString()));
                            } else if (element instanceof Integer) {
                                channel.setHooked(Integer.parseInt(element.toString()) != 0);
                            }
                        }
                        if (key.equalsIgnoreCase("autojoin")) {
                            if (element instanceof Boolean) {
                                channel.setAutoJoin((Boolean)element);
                            } else if (element instanceof String) {
                                channel.setAutoJoin(Boolean.parseBoolean(element.toString()));
                            } else if (element instanceof Integer) {
                                channel.setAutoJoin(Integer.parseInt(element.toString()) != 0);
                            }
                        }
                        if (key.equalsIgnoreCase("default")) {
                            boolean set = false;
                            if (element instanceof Boolean) {
                                set = element != null && (Boolean)element == true;
                            } else if (element instanceof String) {
                                set = Boolean.parseBoolean((String)element);
                            } else if (element instanceof Integer) {
                                boolean bl = set = element != null && (Integer)element != 0;
                            }
                            if (set) {
                                this.plugin.getChannelsHandler().setDefaultChannel(channel);
                                this.plugin.getLogger().info("Default Channel set to " + channel.getName());
                            }
                        }
                        if (key.equalsIgnoreCase("channeltag") && element instanceof String) {
                            channel.setChannelTag(element.toString());
                        }
                        if (key.equalsIgnoreCase("messagecolour") && element instanceof String) {
                            channel.setMessageColour(element.toString());
                        }
                        if (key.equalsIgnoreCase("permission") && element instanceof String) {
                            channel.setPermission(element.toString());
                        }
                        if (key.equalsIgnoreCase("leavepermission") && element instanceof String) {
                            channel.setLeavePermission(element.toString());
                        }
                        if (key.equalsIgnoreCase("craftIRCTag") && element instanceof String) {
                            channel.setCraftIRCTag(element.toString());
                        }
                        if (!key.equalsIgnoreCase("range")) continue;
                        channel.setRange(Double.valueOf(element.toString()));
                    }
                    if (channel.getLeavePermission() == null) {
                        channel.setLeavePermission("towny.chat.leave." + channel.getName().toLowerCase());
                    }
                    this.plugin.getChannelsHandler().addChannel(channel);
                }
                return true;
            }
        }
        return false;
    }

    public boolean loadConfig(String filepath, String defaultRes) {
        String filename = filepath + FileMgmt.fileSeparator() + defaultRes;
        Map<String, Object> file = FileMgmt.getFile(filename, defaultRes, this.plugin);
        if (file != null) {
            for (String Key : file.keySet()) {
                Map allWorlds;
                Map subNodes;
                if (Key.equalsIgnoreCase("spam_time")) {
                    ChatSettings.setSpam_time(Double.parseDouble(file.get(Key).toString()));
                }
                if (Key.equalsIgnoreCase("HeroicDeathToIRC")) {
                    subNodes = (Map)file.get(Key);
                    for (String element : subNodes.keySet()) {
                        if (element.equalsIgnoreCase("enabled")) {
                            ChatSettings.setHeroicDeathToIRC(Boolean.valueOf(subNodes.get(element).toString()));
                        }
                        if (!element.equalsIgnoreCase("craftIRCTags")) continue;
                        ChatSettings.setheroicDeathTags(subNodes.get(element).toString());
                    }
                }
                if (Key.equalsIgnoreCase("modify_chat")) {
                    subNodes = (Map)file.get(Key);
                    for (String element : subNodes.keySet()) {
                        if (element.equalsIgnoreCase("enable")) {
                            ChatSettings.setModify_chat(Boolean.valueOf(subNodes.get(element).toString()));
                        }
                        if (!element.equalsIgnoreCase("per_world")) continue;
                        ChatSettings.setPer_world(Boolean.valueOf(subNodes.get(element).toString()));
                    }
                }
                if (Key.equalsIgnoreCase("colour")) {
                    subNodes = (Map)file.get(Key);
                    for (String element : subNodes.keySet()) {
                        if (element.equalsIgnoreCase("king")) {
                            ChatSettings.setKingColour(subNodes.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("mayor")) {
                            ChatSettings.setMayorColour(subNodes.get(element).toString());
                        }
                        if (!element.equalsIgnoreCase("resident")) continue;
                        ChatSettings.setResidentColour(subNodes.get(element).toString());
                    }
                }
                if (Key.equalsIgnoreCase("tag_formats")) {
                    subNodes = (Map)file.get(Key);
                    for (String element : subNodes.keySet()) {
                        if (element.equalsIgnoreCase("world")) {
                            ChatSettings.setWorldTag(subNodes.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("town")) {
                            ChatSettings.setTownTag(subNodes.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("nation")) {
                            ChatSettings.setNationTag(subNodes.get(element).toString());
                        }
                        if (!element.equalsIgnoreCase("both")) continue;
                        ChatSettings.setBothTags(subNodes.get(element).toString());
                    }
                }
                if (Key.equalsIgnoreCase("channel_formats")) {
                    subNodes = (Map)file.get(Key);
                    channelFormats group = new channelFormats(Key);
                    for (String element : subNodes.keySet()) {
                        if (element.equalsIgnoreCase("global")) {
                            group.setGLOBAL(subNodes.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("town")) {
                            group.setTOWN(subNodes.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("nation")) {
                            group.setNATION(subNodes.get(element).toString());
                        }
                        if (!element.equalsIgnoreCase("default")) continue;
                        group.setDEFAULT(subNodes.get(element).toString());
                    }
                    ChatSettings.addFormatGroup(group);
                }
                if (!Key.equalsIgnoreCase("worlds") || (allWorlds = (Map)file.get(Key)) == null) continue;
                for (String worlds : allWorlds.keySet()) {
                    Map world = (Map)allWorlds.get(worlds);
                    channelFormats group = new channelFormats(worlds);
                    for (String element : world.keySet()) {
                        if (element.equalsIgnoreCase("global")) {
                            group.setGLOBAL(world.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("town")) {
                            group.setTOWN(world.get(element).toString());
                        }
                        if (element.equalsIgnoreCase("nation")) {
                            group.setNATION(world.get(element).toString());
                        }
                        if (!element.equalsIgnoreCase("default")) continue;
                        group.setDEFAULT(world.get(element).toString());
                    }
                    ChatSettings.addFormatGroup(group);
                }
            }
            if (ChatSettings.populateWorldFormats()) {
                this.saveConfig(filename);
            }
            return true;
        }
        return false;
    }

    private void saveConfig(String filepath) {
        File file = new File(filepath);
        if (file.exists() && file.isFile()) {
            try {
                String newConfig = FileMgmt.convertStreamToString("/ChatConfig.yml");
                newConfig = this.setConfigs(newConfig, false);
                FileMgmt.stringToFile(newConfig, filepath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String setConfigs(String newConfig, boolean defaults) {
        String global = "{channelTag} {worldname}{townytagoverride}{townycolor}{permprefix}{group} {townyprefix}{modplayername}{townypostfix}{permsuffix}&f:{msgcolour} {msg}";
        String town = "{channelTag} {townycolor}{permprefix}{townyprefix}{playername}{townypostfix}{permsuffix}&f:{msgcolour} {msg}";
        String nation = "{channelTag}{towntagoverride}{townycolor}{permprefix}{townyprefix}{playername}{townypostfix}{permsuffix}&f:{msgcolour} {msg}";
        String default_ = "{channelTag} {permprefix}{playername}{permsuffix}&f:{msgcolour} {msg}";
        String tag_world = "&f[&f%s&f] ";
        String tag_town = "&f[&3%s&f] ";
        String tag_nation = "&f[&e%s&f] ";
        String tag_both = "&f[&6%s&f|&3%s&f] ";
        String king = "&6";
        String mayor = "&b";
        String resident = "&f";
        newConfig = newConfig.replace("[spam_time]", defaults ? "0.5" : Double.toString(ChatSettings.getSpam_time()));
        newConfig = newConfig.replace("[hd_enable]", defaults ? "true" : Boolean.toString(ChatSettings.isHeroicDeathToIRC()));
        newConfig = newConfig.replace("[hd_tags]", defaults ? "admin" : ChatSettings.getHeroicDeathTags());
        newConfig = newConfig.replace("[globalformat]", defaults ? global : ChatSettings.getFormatGroup("channel_formats").getGLOBAL());
        newConfig = newConfig.replace("[townformat]", defaults ? town : ChatSettings.getFormatGroup("channel_formats").getTOWN());
        newConfig = newConfig.replace("[nationformat]", defaults ? nation : ChatSettings.getFormatGroup("channel_formats").getNATION());
        newConfig = newConfig.replace("[defaultformat]", defaults ? default_ : ChatSettings.getFormatGroup("channel_formats").getDEFAULT());
        newConfig = newConfig.replace("[tag_world]", defaults ? tag_world : ChatSettings.getWorldTag());
        newConfig = newConfig.replace("[tag_town]", defaults ? tag_town : ChatSettings.getTownTag());
        newConfig = newConfig.replace("[tag_nation]", defaults ? tag_nation : ChatSettings.getNationTag());
        newConfig = newConfig.replace("[tag_both]", defaults ? tag_both : ChatSettings.getBothTags());
        newConfig = newConfig.replace("[colour_king]", defaults ? king : ChatSettings.getKingColour());
        newConfig = newConfig.replace("[colour_mayor]", defaults ? mayor : ChatSettings.getMayorColour());
        newConfig = newConfig.replace("[colour_resident]", defaults ? resident : ChatSettings.getResidentColour());
        newConfig = newConfig.replace("[modify_enable]", defaults ? "true" : Boolean.toString(ChatSettings.isModify_chat()));
        newConfig = newConfig.replace("[modify_per_world]", defaults ? "false" : Boolean.toString(ChatSettings.isPer_world()));
        for (String key : ChatSettings.getFormatGroups().keySet()) {
            if (key.equalsIgnoreCase("channel_formats")) continue;
            channelFormats world = ChatSettings.getFormatGroup(key);
            newConfig = newConfig + "    '" + key + "':" + System.getProperty("line.separator");
            newConfig = newConfig + "      global: '" + (defaults ? global : world.getGLOBAL()) + "'" + System.getProperty("line.separator");
            newConfig = newConfig + "      town: '" + (defaults ? town : world.getTOWN()) + "'" + System.getProperty("line.separator");
            newConfig = newConfig + "      nation: '" + (defaults ? nation : world.getNATION()) + "'" + System.getProperty("line.separator");
            newConfig = newConfig + "      default: '" + (defaults ? default_ : world.getDEFAULT()) + "'" + System.getProperty("line.separator");
        }
        return newConfig;
    }
}

