/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.listener;

import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.TownyChatFormatter;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.listener.LocalTownyChatEvent;
import com.palmergames.bukkit.TownyChat.tasks.onPlayerJoinTask;
import com.palmergames.bukkit.TownyChat.util.TownyUtil;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.util.StringMgmt;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class TownyChatPlayerListener
implements Listener {
    private Chat plugin;
    private WeakHashMap<Player, Long> SpamTime = new WeakHashMap();
    private WeakHashMap<Player, String> directedChat = new WeakHashMap();

    public TownyChatPlayerListener(Chat instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        for (Channel channel : this.plugin.getChannelsHandler().getAllChannels().values()) {
            channel.forgetPlayer(name);
        }
        Channel channel = this.plugin.getChannelsHandler().getDefaultChannel();
        if (channel != null && (channel = this.plugin.getChannelsHandler().getChannel(player, channel.getCommands().get(0))) != null) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new onPlayerJoinTask(this.plugin, player, channel), 5L);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String name = event.getPlayer().getName();
        for (Channel channel : this.plugin.getChannelsHandler().getAllChannels().values()) {
            channel.forgetPlayer(name);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Channel channel;
        Player player = event.getPlayer();
        try {
            TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (NotRegisteredException e) {
            return;
        }
        String[] split = event.getMessage().split("\\ ");
        String command = split[0].trim().toLowerCase().replace("/", "");
        String message = "";
        if (split.length > 1) {
            message = StringMgmt.join((Object[])StringMgmt.remFirstArg((String[])split), (String)" ");
        }
        if ((channel = this.plugin.getChannelsHandler().getChannel(player, command)) != null) {
            if (message.isEmpty()) {
                if (this.plugin.getTowny().hasPlayerMode(player, channel.getName())) {
                    Channel nextChannel = null;
                    if (this.plugin.getChannelsHandler().getDefaultChannel() != null && this.plugin.getChannelsHandler().getDefaultChannel().isPresent(player.getName())) {
                        nextChannel = this.plugin.getChannelsHandler().getDefaultChannel();
                        if (!nextChannel.getName().equalsIgnoreCase(channel.getName())) {
                            TownyUtil.removeAndSetPlayerMode(this.plugin.getTowny(), player, channel.getName(), nextChannel.getName(), true);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, (String)"[TownyChat] You are already talking in the default channel. To switch to another channel use that channel's command.");
                        }
                    } else {
                        this.plugin.getTowny().removePlayerMode(player);
                    }
                    if (nextChannel == null) {
                        nextChannel = this.plugin.getChannelsHandler().getActiveChannel(player, channelTypes.GLOBAL);
                    }
                    if (nextChannel != null && !channel.getName().equalsIgnoreCase(nextChannel.getName())) {
                        TownyMessaging.sendMsg((Object)player, (String)("[TownyChat] You are now talking in \u00a7f" + nextChannel.getName()));
                    }
                } else {
                    this.plugin.getTowny().setPlayerMode(player, new String[]{channel.getName()}, true);
                    TownyMessaging.sendMsg((Object)player, (String)("[TownyChat] You are now talking in \u00a7f" + channel.getName()));
                }
            } else {
                if (channel.isMuted(player.getName())) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)("You are currently muted in " + channel.getName() + "!"));
                    event.setCancelled(true);
                    return;
                }
                event.setMessage(message);
                this.directedChat.put(player, command);
                player.chat(message);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.isMuted(player)) {
            Channel channel;
            if (this.isSpam(player)) {
                event.setCancelled(true);
                return;
            }
            if (this.directedChat.containsKey(player)) {
                channel = this.plugin.getChannelsHandler().getChannel(player, this.directedChat.get(player));
                this.directedChat.remove(player);
                if (channel != null) {
                    if (channel.isMuted(player.getName())) {
                        TownyMessaging.sendErrorMsg((Object)player, (String)("You are currently muted in \u00a7f" + channel.getName() + "\u00a7c" + "!"));
                        event.setCancelled(true);
                        return;
                    }
                    this.plugin.getLogger().info("onPlayerChat: Processing directed message for " + channel.getName());
                    channel.chatProcess(event);
                    return;
                }
            }
            for (Channel channel2 : this.plugin.getChannelsHandler().getAllChannels().values()) {
                if (!this.plugin.getTowny().hasPlayerMode(player, channel2.getName())) continue;
                if (channel2.isMuted(player.getName())) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)("You are currently muted in \u00a7f" + channel2.getName() + "\u00a7c" + "!"));
                    event.setCancelled(true);
                    return;
                }
                channel2.chatProcess(event);
                return;
            }
            channel = this.plugin.getChannelsHandler().getActiveChannel(player, channelTypes.GLOBAL);
            if (channel != null) {
                if (channel.isMuted(player.getName())) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)("You are currently muted in \u00a7f" + channel.getName() + "\u00a7c" + "!"));
                    event.setCancelled(true);
                    return;
                }
                channel.chatProcess(event);
                return;
            }
        }
        if (ChatSettings.isModify_chat()) {
            try {
                event.setFormat(ChatSettings.getRelevantFormatGroup(player).getGLOBAL().replace("{channelTag}", "").replace("{msgcolour}", ""));
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                LocalTownyChatEvent chatEvent = new LocalTownyChatEvent(event, resident);
                event.setFormat(TownyChatFormatter.getChatFormat(chatEvent));
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isMuted(Player player) {
        if (this.plugin.getTowny().isEssentials()) {
            try {
                if (this.plugin.getTowny().getEssentials().getUser((Object)player).isMuted()) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)"Unable to talk...You are currently muted!");
                    return true;
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    private boolean isSpam(Player player) {
        long timeNow;
        long spam = timeNow = System.currentTimeMillis();
        if (this.SpamTime.containsKey(player)) {
            spam = this.SpamTime.get(player);
            this.SpamTime.remove(player);
        } else {
            spam = (long)((double)spam - (ChatSettings.getSpam_time() + 1.0) * 1000.0);
        }
        this.SpamTime.put(player, timeNow);
        if ((double)(timeNow - spam) < ChatSettings.getSpam_time() * 1000.0) {
            TownyMessaging.sendErrorMsg((Object)player, (String)"Unable to talk...You are spamming!");
            return true;
        }
        return false;
    }
}

