/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.util;

import com.palmergames.bukkit.TownyChat.Chat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class FileMgmt {
    public static void checkFolders(String[] folders) {
        for (String folder : folders) {
            File f = new File(folder);
            if (f.exists() && f.isDirectory()) continue;
            f.mkdir();
        }
    }

    public static Map<String, Object> getFile(String filepath, String resource, Chat plugin) {
        try {
            Object channelsRootDataNode;
            File f = new File(filepath);
            if (!f.exists() || !f.isFile()) {
                try {
                    String resString = FileMgmt.convertStreamToString("/" + resource);
                    if (plugin != null) {
                        resString = plugin.getConfigurationHandler().setConfigs(resString, true);
                    }
                    FileMgmt.stringToFile(resString, filepath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            f = new File(filepath);
            Yaml yamlChannels = new Yaml((BaseConstructor)new SafeConstructor());
            FileInputStream fileInputStream = new FileInputStream(f);
            try {
                channelsRootDataNode = yamlChannels.load((Reader)new UnicodeReader((InputStream)fileInputStream));
                if (channelsRootDataNode == null) {
                    throw new NullPointerException();
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("The following file couldn't pass on Parser.\n" + f.getPath(), ex);
            }
            finally {
                fileInputStream.close();
            }
            if (channelsRootDataNode instanceof Map) {
                return (Map)channelsRootDataNode;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(String name) throws IOException {
        if (name != null) {
            StringWriter writer = new StringWriter();
            InputStream is = FileMgmt.class.getResourceAsStream(name);
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                System.out.println("Exception ");
            }
            finally {
                try {
                    is.close();
                }
                catch (NullPointerException e) {
                    throw new IOException();
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static boolean stringToFile(String source, String FileName) {
        if (source != null) {
            try {
                return FileMgmt.stringToFile(source, new File(FileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean stringToFile(String source, File file) throws IOException {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            source.replaceAll("\n", System.getProperty("line.separator"));
            out.write(source);
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Exception ");
            return false;
        }
    }

    public static String fileSeparator() {
        return System.getProperty("file.separator");
    }
}

