/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.TownyChat.util;

import com.palmergames.bukkit.TownyChat.util.ReplacerCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringReplaceManager<E> {
    private List<Pattern> replacementPatterns = new ArrayList<Pattern>();
    private List<Object> replacements = new ArrayList<Object>();

    public boolean registerFormatReplacement(String regexKey) {
        return this.registerFormatReplacement(regexKey, null);
    }

    public boolean registerFormatReplacement(String regexKey, Object replacement) {
        Pattern pattern = Pattern.compile(regexKey);
        this.replacementPatterns.add(pattern);
        this.replacements.add(replacement);
        return true;
    }

    public String replaceAll(String format, E e) {
        String out = format;
        for (int i = 0; i < this.replacementPatterns.size(); ++i) {
            Matcher matcher = this.replacementPatterns.get(i).matcher(out);
            Object replacer = this.replacements.get(i);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group();
                if (replacer == null) {
                    matcher.appendReplacement(sb, e.toString());
                    continue;
                }
                if (replacer instanceof String) {
                    matcher.appendReplacement(sb, replacer.toString());
                    continue;
                }
                try {
                    String replacement = ((ReplacerCallable)replacer).call(match, e);
                    matcher.appendReplacement(sb, replacement);
                }
                catch (Exception exception) {}
            }
            matcher.appendTail(sb);
            out = sb.toString();
        }
        return out;
    }

    public static void main(String[] args) {
        String regex = "\\+{1}[a-zA-Z]+";
        String s = "+meh asdf+lo";
        StringReplaceManager<String> replacer = new StringReplaceManager<String>();
        replacer.registerFormatReplacement(regex, "1");
        System.out.println(replacer.replaceAll(s, "2"));
        replacer = new StringReplaceManager();
        replacer.registerFormatReplacement(regex);
        System.out.println(replacer.replaceAll(s, "2"));
        int times = 1000;
        long t = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            s.replaceAll(regex, "2");
        }
        System.out.println("Runtime: " + (double)(System.currentTimeMillis() - t) / (double)times);
        t = System.currentTimeMillis();
        StringReplaceManager<String> replacer2 = new StringReplaceManager<String>();
        replacer2.registerFormatReplacement(regex);
        for (int i = 0; i < times; ++i) {
            replacer2.replaceAll(s, "2");
        }
        System.out.println("Precompiled: " + (double)(System.currentTimeMillis() - t) / (double)times);
    }
}

