/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Database;

import com.Acrobot.Breeze.Database.EntityParser;
import com.Acrobot.Breeze.Database.Table;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.persistence.Entity;

public class Database {
    private String uri;
    private String username;
    private String password;

    public Database(String uri, String username, String password) {
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public Database(String uri) {
        this.uri = uri;
        this.username = null;
        this.password = null;
    }

    public Table getTable(String name) {
        return new Table(this, name);
    }

    public boolean createFromClass(Class clazz) {
        if (!clazz.isAnnotationPresent(Entity.class) || !clazz.isAnnotationPresent(javax.persistence.Table.class)) {
            return false;
        }
        String tableName = clazz.getAnnotation(javax.persistence.Table.class).name();
        Table table = this.getTable(tableName);
        EntityParser parser = new EntityParser(clazz);
        String fields = parser.parseToString();
        try {
            table.create(fields);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.uri, this.username, this.password);
    }
}

