/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Database;

import com.google.common.base.Joiner;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.LinkedList;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

public class EntityParser {
    private Class entity;

    public EntityParser(Class table) {
        if (!table.isAnnotationPresent(Entity.class) || !table.isAnnotationPresent(Table.class)) {
            throw new AnnotationFormatError("The class hasn't got Entity or Table annotation!");
        }
        this.entity = table;
    }

    public String parseToString() {
        LinkedList<String> fields = new LinkedList<String>();
        for (Field field : this.entity.getDeclaredFields()) {
            fields.add(EntityParser.convertToSQL(field));
        }
        return Joiner.on((char)',').join(fields);
    }

    public static String convertToSQL(Field field) {
        String sqlType = field.getName();
        Class<Comparable<Boolean>> type = field.getType();
        sqlType = type.isAssignableFrom(Boolean.TYPE) ? sqlType + " BOOLEAN" : (type.isAssignableFrom(Integer.TYPE) ? sqlType + " INTEGER" : (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Float.TYPE) ? sqlType + " REAL" : sqlType + " TEXT"));
        if (field.isAnnotationPresent(Id.class)) {
            sqlType = sqlType + " PRIMARY KEY";
        }
        return sqlType;
    }
}

