/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Database;

import com.Acrobot.Breeze.Database.Database;
import com.Acrobot.Breeze.Database.Row;
import com.Acrobot.Breeze.Database.RowSet;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class Table {
    private final Database database;
    private final String name;
    private final String SELECT_ALL;
    private final String SELECT_STATEMENT;
    private final String INSERT_VALUES;
    private final String UPDATE;
    private final String CREATE;

    public Table(Database database, String name) {
        this.database = database;
        this.name = name;
        this.SELECT_ALL = "SELECT * FROM " + name;
        this.SELECT_STATEMENT = "SELECT * FROM " + name + " WHERE %s";
        this.INSERT_VALUES = "INSERT OR IGNORE INTO " + name + " VALUES (%s)";
        this.UPDATE = "UPDATE " + name + " SET %s WHERE %s";
        this.CREATE = "CREATE TABLE IF NOT EXISTS " + name + " (%s)";
    }

    private RowSet select(String criteria) throws SQLException {
        Connection connection = this.database.getConnection();
        Statement statement = connection.createStatement();
        String query = criteria == null || criteria.isEmpty() ? this.SELECT_ALL : this.SELECT_STATEMENT;
        query = String.format(query, criteria);
        ResultSet results = statement.executeQuery(query);
        ResultSetMetaData metaData = results.getMetaData();
        RowSet rowSet = new RowSet();
        int columnCount = metaData.getColumnCount();
        while (results.next()) {
            Row row = new Row();
            for (int i = 1; i <= columnCount; ++i) {
                String name = metaData.getColumnName(i);
                String value = results.getString(i);
                row.put(name, value);
            }
            rowSet.add(row);
        }
        results.close();
        statement.close();
        connection.close();
        return rowSet;
    }

    public Row getRow(String criteria) throws SQLException {
        RowSet rs = this.select(criteria);
        return rs.size() > 0 ? rs.get(0) : new Row();
    }

    public RowSet getRows(String criteria) throws SQLException {
        return this.select(criteria);
    }

    public RowSet getRows() throws SQLException {
        return this.getRows(null);
    }

    public void insertRow(Row row) throws SQLException {
        this.insertRow(row, null);
    }

    public void insertRow(Row row, String condition) throws SQLException {
        String statement;
        String format;
        if (condition == null || condition.isEmpty()) {
            format = '\'' + Joiner.on((String)"', ").join(row.getValues()) + '\'';
            statement = String.format(this.INSERT_VALUES, format);
        } else {
            format = Joiner.on((String)"', ").withKeyValueSeparator("= '").join(row.getKeysAndValues()) + '\'';
            statement = String.format(this.UPDATE, format, condition);
        }
        Connection connection = this.database.getConnection();
        Statement stm = connection.createStatement();
        stm.executeUpdate(statement);
        stm.close();
        connection.close();
    }

    public void insertRow(String statement) throws SQLException {
        this.insertRow(statement, null);
    }

    public void insertRow(String statement, String condition) throws SQLException {
        statement = condition == null || condition.isEmpty() ? String.format(this.INSERT_VALUES, statement) : String.format(this.UPDATE, statement, condition);
        Connection connection = this.database.getConnection();
        Statement stm = connection.createStatement();
        stm.executeUpdate(statement);
        connection.close();
        stm.close();
    }

    public void create(String fields) throws SQLException {
        String statement = String.format(this.CREATE, fields);
        Connection connection = this.database.getConnection();
        Statement stm = connection.createStatement();
        stm.executeUpdate(statement);
        stm.close();
        connection.close();
    }

    public String getName() {
        return this.name;
    }
}

