/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import info.somethingodd.bukkit.OddItem.OddItem;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.CoalType;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Coal;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;
import org.bukkit.material.TexturedMaterial;
import org.bukkit.material.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialUtil {
    public static final Pattern DURABILITY = Pattern.compile(":(\\d)*");
    public static final Pattern ENCHANTMENT = Pattern.compile("-([0-9a-zA-Z])*");
    public static final Pattern METADATA = Pattern.compile("#([0-9a-zA-Z])*");
    public static final boolean LONG_NAME = true;
    public static final boolean SHORT_NAME = false;
    private static final Map<String, Material> MATERIAL_CACHE = new HashMap<String, Material>();

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static boolean equals(ItemStack one, ItemStack two) {
        return one.isSimilar(two);
    }

    public static Material getMaterial(String name) {
        String formatted = name.replaceAll(" |_", "").toUpperCase();
        if (MATERIAL_CACHE.containsKey(formatted)) {
            return MATERIAL_CACHE.get(formatted);
        }
        Material material = Material.matchMaterial((String)name);
        if (material != null) {
            MATERIAL_CACHE.put(formatted, material);
            return material;
        }
        int length = Short.MAX_VALUE;
        for (Material currentMaterial : Material.values()) {
            String matName = currentMaterial.name();
            if (matName.length() >= length || !matName.replace("_", "").startsWith(formatted)) continue;
            length = (short)matName.length();
            material = currentMaterial;
        }
        MATERIAL_CACHE.put(formatted, material);
        return material;
    }

    public static String getName(ItemStack itemStack) {
        return MaterialUtil.getName(itemStack, true);
    }

    public static String getName(ItemStack itemStack, boolean showDataValue) {
        String dataName = DataValue.name(itemStack);
        if (dataName != null && showDataValue) {
            return StringUtil.capitalizeFirstLetter(dataName + '_' + itemStack.getType(), '_');
        }
        return StringUtil.capitalizeFirstLetter(itemStack.getType().toString(), '_');
    }

    public static String getSignName(ItemStack itemStack) {
        StringBuilder name = new StringBuilder(15);
        name.append(itemStack.getType().name());
        if (itemStack.getDurability() != 0) {
            name.append(':').append(itemStack.getDurability());
        }
        if (itemStack.hasItemMeta()) {
            name.append('#').append(Metadata.getItemCode(itemStack));
        }
        return StringUtil.capitalizeFirstLetter(name.toString(), '_');
    }

    public static ItemStack getItem(String itemName) {
        ItemStack itemStack = Odd.getFromString(itemName);
        if (itemStack != null) {
            return itemStack;
        }
        String[] split = (String[])Iterables.toArray((Iterable)Splitter.onPattern((String)":|-|#").trimResults().split((CharSequence)itemName), String.class);
        Material material = MaterialUtil.getMaterial(split[0]);
        short durability = MaterialUtil.getDurability(itemName);
        if (material == null) {
            if (!split[0].contains(" ")) {
                return null;
            }
            int index = split[0].indexOf(32);
            while (index >= 0) {
                material = MaterialUtil.getMaterial(split[0].substring(index));
                if (material != null) {
                    if (durability != 0) break;
                    durability = DataValue.get(split[0].substring(0, index), material);
                    break;
                }
                index = split[0].indexOf(32, index + 1);
            }
            if (material == null) {
                return null;
            }
        }
        itemStack = new ItemStack(material);
        itemStack.setDurability(durability);
        ItemMeta meta = MaterialUtil.getMetadata(itemName);
        if (meta != null) {
            itemStack.setItemMeta(meta);
        } else {
            Map<org.bukkit.enchantments.Enchantment, Integer> enchantments = MaterialUtil.getEnchantments(itemName);
            if (enchantments != null) {
                try {
                    itemStack.addEnchantments(enchantments);
                }
                catch (IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        return itemStack;
    }

    public static short getDurability(String itemName) {
        Matcher m = DURABILITY.matcher(itemName);
        if (!m.find()) {
            return 0;
        }
        String data = m.group();
        if (data == null || data.isEmpty()) {
            return 0;
        }
        return NumberUtil.isShort(data = data.substring(1)) ? Short.valueOf(data) : (short)0;
    }

    public static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(String itemName) {
        Matcher m = ENCHANTMENT.matcher(itemName);
        if (!m.find()) {
            return null;
        }
        String group = m.group().substring(1);
        return Enchantment.getEnchantments(group);
    }

    public static ItemMeta getMetadata(String itemName) {
        Matcher m = METADATA.matcher(itemName);
        if (!m.find()) {
            return null;
        }
        String group = m.group().substring(1);
        return Metadata.getFromCode(group);
    }

    public static class Odd {
        private static boolean isInitialized = false;

        public static ItemStack getFromString(String itemName) {
            if (!isInitialized) {
                return null;
            }
            String name = itemName.replace(':', ';');
            try {
                return OddItem.getItemStack((String)name);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static void initialize() {
            isInitialized = true;
        }
    }

    public static class Metadata {
        public static ItemMeta getFromCode(String code) {
            ItemStack item = ChestShop.getItemDatabase().getFromCode(code);
            if (item == null) {
                return null;
            }
            return item.getItemMeta();
        }

        public static String getItemCode(ItemStack item) {
            return ChestShop.getItemDatabase().getItemCode(item);
        }
    }

    public static class DataValue {
        public static byte get(String type, Material material) {
            if (material == null || material.getData() == null) {
                return 0;
            }
            type = type.toUpperCase().replace(" ", "_");
            MaterialData materialData = material.getNewData((byte)0);
            if (materialData instanceof TexturedMaterial) {
                TexturedMaterial texturedMaterial = (TexturedMaterial)materialData;
                for (Material mat : texturedMaterial.getTextures()) {
                    if (!mat.name().startsWith(type) || mat.equals((Object)material)) continue;
                    return (byte)texturedMaterial.getTextures().indexOf(mat);
                }
            } else {
                if (materialData instanceof Colorable) {
                    DyeColor color;
                    try {
                        color = DyeColor.valueOf((String)type);
                    }
                    catch (IllegalArgumentException exception) {
                        return 0;
                    }
                    if (material == Material.INK_SACK) {
                        return color.getDyeData();
                    }
                    return color.getWoolData();
                }
                if (materialData instanceof Tree) {
                    try {
                        return TreeSpecies.valueOf((String)type).getData();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
                if (materialData instanceof SpawnEgg) {
                    try {
                        EntityType entityType = EntityType.valueOf((String)type);
                        return (byte)entityType.getTypeId();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
                if (materialData instanceof Coal) {
                    try {
                        return CoalType.valueOf((String)type).getData();
                    }
                    catch (IllegalArgumentException ex) {
                        return 0;
                    }
                }
            }
            return 0;
        }

        public static String name(ItemStack itemStack) {
            MaterialData data = itemStack.getData();
            if (data == null) {
                return null;
            }
            if (data instanceof TexturedMaterial) {
                return ((TexturedMaterial)data).getMaterial().name();
            }
            if (data instanceof Colorable) {
                DyeColor color = ((Colorable)data).getColor();
                return color != null ? color.name() : null;
            }
            if (data instanceof Tree) {
                TreeSpecies specie = ((Tree)data).getSpecies();
                return specie != null && specie != TreeSpecies.GENERIC ? specie.name() : null;
            }
            if (data instanceof SpawnEgg) {
                EntityType type = ((SpawnEgg)data).getSpawnedType();
                return type != null ? type.name() : null;
            }
            if (data instanceof Coal) {
                CoalType coal = ((Coal)data).getType();
                return coal != null && coal != CoalType.COAL ? coal.name() : null;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enchantment {
        public static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(String base32) {
            if (base32 == null || base32.isEmpty() || !NumberUtil.isEnchantment(base32)) {
                return new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
            }
            StringBuilder number = new StringBuilder(Long.toString(Long.parseLong(base32, 32)));
            HashMap<org.bukkit.enchantments.Enchantment, Integer> map = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
            while (number.length() % 3 != 0) {
                number.insert(0, '0');
            }
            for (int i = 0; i < number.length() / 3; ++i) {
                int level;
                String item = number.substring(i * 3, i * 3 + 3);
                org.bukkit.enchantments.Enchantment enchantment = org.bukkit.enchantments.Enchantment.getById((int)Integer.parseInt(item.substring(0, 2)));
                if (enchantment == null || (level = Integer.parseInt(item.substring(2))) > enchantment.getMaxLevel() || level < enchantment.getStartLevel()) continue;
                map.put(enchantment, level);
            }
            return map;
        }

        public static String encodeEnchantment(Map<org.bukkit.enchantments.Enchantment, Integer> enchantments) {
            long number = 0L;
            for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> entry : enchantments.entrySet()) {
                number = number * 1000L + (long)(entry.getKey().getId() * 10) + (long)entry.getValue().intValue();
            }
            return number != 0L ? Long.toString(number, 32) : null;
        }

        public static String encodeEnchantment(ItemStack item) {
            return Enchantment.encodeEnchantment(item.getEnchantments());
        }
    }
}

