/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.Breeze.Configuration.Configuration;
import com.Acrobot.ChestShop.Commands.ItemInfo;
import com.Acrobot.ChestShop.Commands.Version;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.DB.Generator;
import com.Acrobot.ChestShop.DB.Queue;
import com.Acrobot.ChestShop.DB.Transaction;
import com.Acrobot.ChestShop.Dependencies;
import com.Acrobot.ChestShop.Listeners.Block.BlockPlace;
import com.Acrobot.ChestShop.Listeners.Block.Break.ChestBreak;
import com.Acrobot.ChestShop.Listeners.Block.Break.SignBreak;
import com.Acrobot.ChestShop.Listeners.Block.SignCreate;
import com.Acrobot.ChestShop.Listeners.Item.ItemMoveListener;
import com.Acrobot.ChestShop.Listeners.ItemInfoListener;
import com.Acrobot.ChestShop.Listeners.Player.PlayerConnect;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInteract;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInventory;
import com.Acrobot.ChestShop.Listeners.Player.ShortNameSaver;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.CreationFeeGetter;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.MessageSender;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.SignSticker;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EconomicModule;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EmptyShopDeleter;
import com.Acrobot.ChestShop.Listeners.PostTransaction.ItemManager;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionLogger;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionMessageSender;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ChestChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ErrorMessageSender;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ItemChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.MoneyChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.NameChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceRatioChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.QuantityChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.TerrainChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.AmountAndPriceChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.CreativeModeIgnorer;
import com.Acrobot.ChestShop.Listeners.PreTransaction.DiscountModule;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PartialTransactionModule;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PermissionChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PriceValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.ShopValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.SpamClickProtector;
import com.Acrobot.ChestShop.Listeners.PreTransaction.StockFittingChecker;
import com.Acrobot.ChestShop.Listeners.ShopRefundListener;
import com.Acrobot.ChestShop.Logging.FileFormatter;
import com.Acrobot.ChestShop.Metadata.ItemDatabase;
import com.Acrobot.ChestShop.Metrics;
import com.Acrobot.ChestShop.Signs.RestrictedSign;
import com.Acrobot.ChestShop.Utils.uName;
import com.avaje.ebean.EbeanServer;
import com.lennardf1989.bukkitex.Database;
import com.nijikokun.register.payment.forChestShop.Methods;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChestShop
extends JavaPlugin {
    private static ChestShop plugin;
    private static Server server;
    private static PluginDescriptionFile description;
    private static File dataFolder;
    private static EbeanServer database;
    private static ItemDatabase itemDatabase;
    private static Logger logger;
    private FileHandler handler;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        dataFolder = this.getDataFolder();
        description = this.getDescription();
        server = this.getServer();
        Configuration.pairFileAndClass(ChestShop.loadFile("config.yml"), Properties.class);
        Configuration.pairFileAndClass(ChestShop.loadFile("local.yml"), Messages.class);
        itemDatabase = new ItemDatabase();
        uName.file = ChestShop.loadFile("longName.storage");
        uName.load();
        Methods.setPreferred(Properties.PREFERRED_ECONOMY_PLUGIN);
        Dependencies.load();
        this.registerEvents();
        if (Properties.LOG_TO_DATABASE || Properties.GENERATE_STATISTICS_PAGE) {
            this.setupDB();
        }
        if (Properties.GENERATE_STATISTICS_PAGE) {
            File htmlFolder = new File(Properties.STATISTICS_PAGE_PATH);
            this.scheduleTask(new Generator(htmlFolder), 300L, Properties.STATISTICS_PAGE_GENERATION_INTERVAL * 20L);
        }
        if (Properties.LOG_TO_FILE) {
            File log = ChestShop.loadFile("ChestShop.log");
            FileHandler handler = ChestShop.loadHandler(log.getAbsolutePath());
            handler.setFormatter(new FileFormatter());
            this.handler = handler;
            logger.addHandler(handler);
        }
        if (!Properties.LOG_TO_CONSOLE) {
            logger.setUseParentHandlers(false);
        }
        this.getCommand("iteminfo").setExecutor((CommandExecutor)new ItemInfo());
        this.getCommand("csVersion").setExecutor((CommandExecutor)new Version());
        this.startStatistics();
    }

    public static File loadFile(String string) {
        File file = new File(dataFolder, string);
        return ChestShop.loadFile(file);
    }

    private static File loadFile(File file) {
        if (!file.exists()) {
            try {
                if (file.getParent() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static FileHandler loadHandler(String path) {
        FileHandler handler = null;
        try {
            handler = new FileHandler(path, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return handler;
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.handler != null) {
            this.handler.close();
            this.getLogger().removeHandler(this.handler);
        }
    }

    private void registerEvents() {
        this.registerEvent(new com.Acrobot.ChestShop.Plugins.ChestShop());
        this.registerPreShopCreationEvents();
        this.registerPreTransactionEvents();
        this.registerPostShopCreationEvents();
        this.registerPostTransactionEvents();
        this.registerEvent(new SignBreak());
        this.registerEvent(new SignCreate());
        this.registerEvent(new ChestBreak());
        this.registerEvent(new BlockPlace());
        this.registerEvent(new ItemMoveListener());
        this.registerEvent(new PlayerConnect());
        this.registerEvent(new PlayerInteract());
        this.registerEvent(new PlayerInventory());
        this.registerEvent(new ItemInfoListener());
        this.registerEvent(new RestrictedSign());
        this.registerEvent(new ShopRefundListener());
        this.registerEvent(new ShortNameSaver());
    }

    private void registerPreShopCreationEvents() {
        if (Properties.BLOCK_SHOPS_WITH_SELL_PRICE_HIGHER_THAN_BUY_PRICE) {
            this.registerEvent(new PriceRatioChecker());
        }
        this.registerEvent(new ChestChecker());
        this.registerEvent(new ItemChecker());
        this.registerEvent(new MoneyChecker());
        this.registerEvent(new NameChecker());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreShopCreation.PermissionChecker());
        this.registerEvent(new ErrorMessageSender());
        this.registerEvent(new PriceChecker());
        this.registerEvent(new QuantityChecker());
        this.registerEvent(new TerrainChecker());
    }

    private void registerPostShopCreationEvents() {
        this.registerEvent(new CreationFeeGetter());
        this.registerEvent(new MessageSender());
        this.registerEvent(new SignSticker());
    }

    private void registerPreTransactionEvents() {
        if (Properties.ALLOW_PARTIAL_TRANSACTIONS) {
            this.registerEvent(new PartialTransactionModule());
        } else {
            this.registerEvent(new AmountAndPriceChecker());
        }
        this.registerEvent(new CreativeModeIgnorer());
        this.registerEvent(new DiscountModule());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreTransaction.ErrorMessageSender());
        this.registerEvent(new PermissionChecker());
        this.registerEvent(new PriceValidator());
        this.registerEvent(new ShopValidator());
        this.registerEvent(new SpamClickProtector());
        this.registerEvent(new StockFittingChecker());
    }

    private void registerPostTransactionEvents() {
        this.registerEvent(new EconomicModule());
        this.registerEvent(new EmptyShopDeleter());
        this.registerEvent(new ItemManager());
        this.registerEvent(new TransactionLogger());
        this.registerEvent(new TransactionMessageSender());
    }

    public void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void scheduleTask(Runnable runnable, long startTime, long repetetionTime) {
        server.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, startTime, repetetionTime);
    }

    private void startStatistics() {
        try {
            new Metrics((Plugin)this).start();
        }
        catch (IOException ex) {
            ChestShop.getBukkitLogger().severe("There was an error while submitting statistics.");
        }
    }

    private void setupDB() {
        ChestShop.loadFile(new File("ebean.properties"));
        Database DB = new Database(this){

            @Override
            protected List<Class<?>> getDatabaseClasses() {
                ArrayList list = new ArrayList();
                list.add(Transaction.class);
                return list;
            }
        };
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml"));
        DB.initializeDatabase(config.getString("database.driver"), config.getString("database.url"), config.getString("database.username"), config.getString("database.password"), config.getString("database.isolation"));
        database = DB.getDatabase();
        this.scheduleTask(new Queue(), 200L, 200L);
    }

    public EbeanServer getDatabase() {
        return database;
    }

    public static ItemDatabase getItemDatabase() {
        return itemDatabase;
    }

    public static File getFolder() {
        return dataFolder;
    }

    public static Logger getBukkitLogger() {
        return logger;
    }

    public static Server getBukkitServer() {
        return server;
    }

    public static String getVersion() {
        return description.getVersion();
    }

    public static String getPluginName() {
        return description.getName();
    }

    public static EbeanServer getDB() {
        return database;
    }

    public static List<String> getDependencies() {
        return description.getSoftDepend();
    }

    public static ChestShop getPlugin() {
        return plugin;
    }

    public static void registerListener(Listener listener) {
        plugin.registerEvent(listener);
    }

    public static void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }
}

