/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Configuration;

import com.Acrobot.ChestShop.ChestShop;
import java.io.File;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MaxPrice {
    private static Configuration config = YamlConfiguration.loadConfiguration((File)ChestShop.loadFile("config.yml"));

    public static boolean canCreate(double buyPrice, double sellPrice, Material mat) {
        return MaxPrice.buyPriceWithinRange(buyPrice, mat) && MaxPrice.sellPriceWithinRange(sellPrice, mat);
    }

    private static boolean buyPriceWithinRange(double buyPrice, Material material) {
        double bPrice = MaxPrice.maxBuyPrice(material);
        double maxPrice = MaxPrice.maxBuyPrice();
        return buyPrice <= bPrice && buyPrice <= maxPrice;
    }

    private static boolean sellPriceWithinRange(double sellPrice, Material material) {
        double sPrice = MaxPrice.maxSellPrice(material);
        double maxPrice = MaxPrice.maxSellPrice();
        return sellPrice <= sPrice && sellPrice <= maxPrice;
    }

    public static double maxBuyPrice() {
        return MaxPrice.getPrice(Price.buy);
    }

    public static double maxSellPrice() {
        return MaxPrice.getPrice(Price.sell);
    }

    public static double maxBuyPrice(Material material) {
        return MaxPrice.getPrice(Price.buy, material.getId());
    }

    public static double maxSellPrice(Material material) {
        return MaxPrice.getPrice(Price.sell, material.getId());
    }

    public static double getPrice(Price price) {
        return MaxPrice.getPrice(price, -1);
    }

    public static double getPrice(Price price, int itemID) {
        String node = "max-" + (Object)((Object)price) + "-price" + (itemID > 0 ? "-" + itemID : "");
        return config.isSet(node) ? config.getDouble(node) : Double.MAX_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Price {
        buy,
        sell;

    }
}

