/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.DB;

import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.DB.Transaction;
import com.avaje.ebean.ExpressionList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.persistence.PersistenceException;
import org.bukkit.Material;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
implements Runnable {
    private final File pagePath;
    private static String header;
    private static String row;
    private static String footer;
    private static BufferedWriter buf;

    public Generator(File pagePath) {
        this.pagePath = pagePath;
    }

    @Override
    public void run() {
        header = Generator.fileToString("header");
        row = Generator.fileToString("row");
        footer = Generator.fileToString("footer");
        if (row.isEmpty()) {
            ChestShop.getBukkitLogger().severe("You lack the necessary HTML files in your plugins/ChestShop/HTML folder!");
            return;
        }
        this.generateStats();
    }

    private void fileStart() throws IOException {
        FileWriter fw = new FileWriter(this.pagePath);
        fw.write(header);
        fw.close();
    }

    private void fileEnd(long generationTime) throws IOException {
        FileWriter fw = new FileWriter(this.pagePath, true);
        fw.write(footer.replace("%time", String.valueOf(generationTime)));
        fw.close();
    }

    private static String fileToString(String fileName) {
        try {
            File htmlFolder = new File(ChestShop.getFolder(), "HTML");
            File fileToRead = new File(htmlFolder, fileName + ".html");
            FileReader rd = new FileReader(fileToRead);
            char[] buf = new char[(int)fileToRead.length()];
            rd.read(buf);
            return new String(buf);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static double generateItemTotal(int itemID, boolean bought, boolean sold) {
        ExpressionList checkIf = ChestShop.getDB().find(Transaction.class).where();
        List list = bought || sold ? checkIf.eq("buy", (Object)(bought ? 1 : 0)).eq("itemID", (Object)itemID).findList() : checkIf.eq("itemID", (Object)itemID).findList();
        return Generator.countTransactionAmount(list);
    }

    private static double countTransactionAmount(List<Transaction> list) {
        double amount = 0.0;
        for (Transaction transaction : list) {
            amount += (double)transaction.getAmount();
        }
        return amount;
    }

    private static double generateTotalBought(int itemID) {
        return Generator.generateItemTotal(itemID, true, false);
    }

    private static double generateTotalSold(int itemID) {
        return Generator.generateItemTotal(itemID, false, true);
    }

    private static double generateItemTotal(int itemID) {
        return Generator.generateItemTotal(itemID, false, false);
    }

    private static float generateAveragePrice(int itemID) {
        float price = 0.0f;
        List prices = ChestShop.getDB().find(Transaction.class).where().eq("itemID", (Object)itemID).eq("buy", (Object)true).findList();
        for (Transaction t : prices) {
            price += t.getAveragePricePerItem();
        }
        float toReturn = price / (float)prices.size();
        return !Float.isNaN(toReturn) ? toReturn : 0.0f;
    }

    private static float generateAverageBuyPrice(int itemID) {
        return Generator.generateAveragePrice(itemID);
    }

    private static void generateItemStats(int itemID) throws IOException {
        double total = Generator.generateItemTotal(itemID);
        if (total == 0.0) {
            return;
        }
        double bought = Generator.generateTotalBought(itemID);
        double sold = Generator.generateTotalSold(itemID);
        Material material = Material.getMaterial((int)itemID);
        String matName = StringUtil.capitalizeFirstLetter(material.name(), '_');
        int maxStackSize = material.getMaxStackSize();
        float buyPrice = Generator.generateAverageBuyPrice(itemID);
        buf.write(row.replace("%material", matName).replace("%total", String.valueOf(total)).replace("%bought", String.valueOf(bought)).replace("%sold", String.valueOf(sold)).replace("%maxStackSize", String.valueOf(maxStackSize)).replace("%pricePerStack", String.valueOf(buyPrice * (float)maxStackSize)).replace("%pricePerItem", String.valueOf(buyPrice)));
    }

    private void generateStats() {
        block4: {
            try {
                File parentFolder = this.pagePath.getParentFile();
                if (!parentFolder.exists()) {
                    parentFolder.mkdir();
                }
                this.fileStart();
                buf = new BufferedWriter(new FileWriter(this.pagePath, true));
                long genTime = System.currentTimeMillis();
                for (Material m : Material.values()) {
                    Generator.generateItemStats(m.getId());
                }
                buf.close();
                long generationTime = (System.currentTimeMillis() - genTime) / 1000L;
                this.fileEnd(generationTime);
            }
            catch (Exception e) {
                ChestShop.getBukkitLogger().severe("Couldn't generate statistics page!");
                if (e instanceof PersistenceException) break block4;
                e.printStackTrace();
            }
        }
    }
}

