/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Economy;

import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Economy.EconomyManager;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uName;
import org.bukkit.inventory.Inventory;

public class Economy {
    private static EconomyManager manager = new EconomyManager();

    public static boolean transactionCanFail() {
        return manager.transactionCanFail();
    }

    public static boolean isOwnerEconomicallyActive(Inventory inventory) {
        return !ChestShopSign.isAdminShop(inventory) || !Economy.getServerAccountName().isEmpty();
    }

    public static boolean hasAccount(String player) {
        return !player.isEmpty() && manager.hasAccount(uName.getName(player));
    }

    public static String getServerAccountName() {
        return Properties.SERVER_ECONOMY_ACCOUNT;
    }

    public static boolean isServerAccount(String acc) {
        return ChestShopSign.isAdminShop(acc);
    }

    public static boolean add(String name, double amount) {
        float taxAmount;
        double tax;
        if (Economy.isServerAccount(name)) {
            if (!Economy.getServerAccountName().isEmpty()) {
                name = Economy.getServerAccountName();
            } else {
                return true;
            }
        }
        if ((tax = Economy.getTax(taxAmount = Economy.isServerAccount(name) ? (float)Properties.SERVER_TAX_AMOUNT : (float)Properties.TAX_AMOUNT, amount)) != 0.0) {
            if (!Economy.getServerAccountName().isEmpty()) {
                manager.add(Economy.getServerAccountName(), tax);
            }
            amount -= tax;
        }
        return manager.add(uName.getName(name), amount);
    }

    public static double getTax(float tax, double price) {
        return NumberUtil.roundDown((double)(tax / 100.0f) * price);
    }

    public static boolean subtract(String name, double amount) {
        if (Economy.isServerAccount(name)) {
            if (!Economy.getServerAccountName().isEmpty()) {
                name = Economy.getServerAccountName();
            } else {
                return true;
            }
        }
        return manager.subtract(uName.getName(name), NumberUtil.roundUp(amount));
    }

    public static boolean canHold(String name, double amount) {
        if (!Economy.transactionCanFail()) {
            return true;
        }
        if (Economy.isServerAccount(name)) {
            if (!Economy.getServerAccountName().isEmpty()) {
                name = Economy.getServerAccountName();
            } else {
                return true;
            }
        }
        if (!manager.add(name = uName.getName(name), amount)) {
            return false;
        }
        manager.subtract(name, amount);
        return true;
    }

    public static boolean hasEnough(String name, double amount) {
        if (amount <= 0.0) {
            return true;
        }
        if (Economy.isServerAccount(name)) {
            if (!Economy.getServerAccountName().isEmpty()) {
                name = Economy.getServerAccountName();
            } else {
                return true;
            }
        }
        return manager.hasEnough(uName.getName(name), NumberUtil.roundUp(amount));
    }

    public static double getBalance(String name) {
        if (Economy.isServerAccount(name)) {
            if (!Economy.getServerAccountName().isEmpty()) {
                name = Economy.getServerAccountName();
            } else {
                return Double.MAX_VALUE;
            }
        }
        return manager.balance(uName.getName(name));
    }

    public static String formatBalance(double amount) {
        return manager.format(NumberUtil.roundUp(amount));
    }

    public static void setPlugin(EconomyManager plugin) {
        manager = plugin;
    }

    public static EconomyManager getManager() {
        return manager;
    }

    public static boolean isLoaded() {
        return manager.getClass() != EconomyManager.class;
    }
}

