/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Economy;

import com.Acrobot.ChestShop.Economy.EconomyManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Vault
extends EconomyManager {
    private static Economy vaultPlugin;

    public boolean transactionCanFail() {
        return Vault.getPluginName().equals("Gringotts") || Vault.getPluginName().equals("GoldIsMoney") || Vault.getPluginName().equals("MultiCurrency");
    }

    public boolean hasAccount(String player) {
        return vaultPlugin.hasAccount(player);
    }

    public boolean add(String player, double amount) {
        return vaultPlugin.depositPlayer(player, amount).transactionSuccess();
    }

    public boolean subtract(String player, double amount) {
        return vaultPlugin.withdrawPlayer(player, amount).transactionSuccess();
    }

    public boolean hasEnough(String player, double amount) {
        return vaultPlugin.has(player, amount);
    }

    public double balance(String player) {
        return vaultPlugin.getBalance(player);
    }

    public String format(double amount) {
        return vaultPlugin.format(amount);
    }

    public static String getPluginName() {
        if (vaultPlugin == null) {
            return "";
        }
        return vaultPlugin.getName();
    }

    public static Vault getVault() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return null;
        }
        vaultPlugin = (Economy)rsp.getProvider();
        if (vaultPlugin == null) {
            return null;
        }
        return new Vault();
    }
}

