/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PreTransactionEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final Player client;
    private OfflinePlayer owner;
    private final TransactionEvent.TransactionType transactionType;
    private final Sign sign;
    private Inventory ownerInventory;
    private Inventory clientInventory;
    private ItemStack[] items;
    private double price;
    private TransactionOutcome transactionOutcome = TransactionOutcome.TRANSACTION_SUCCESFUL;

    public PreTransactionEvent(Inventory ownerInventory, Inventory clientInventory, ItemStack[] items, double price, Player client, OfflinePlayer owner, Sign sign, TransactionEvent.TransactionType type) {
        this.ownerInventory = ownerInventory;
        this.clientInventory = clientInventory == null ? client.getInventory() : clientInventory;
        this.items = items;
        this.price = price;
        this.client = client;
        this.owner = owner;
        this.sign = sign;
        this.transactionType = type;
    }

    public Sign getSign() {
        return this.sign;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void setStock(ItemStack ... stock) {
        this.items = stock;
    }

    public ItemStack[] getStock() {
        return this.items;
    }

    public Player getClient() {
        return this.client;
    }

    public OfflinePlayer getOwner() {
        return this.owner;
    }

    public void setOwner(OfflinePlayer owner) {
        this.owner = owner;
    }

    public Inventory getOwnerInventory() {
        return this.ownerInventory;
    }

    public void setOwnerInventory(Inventory ownerInventory) {
        this.ownerInventory = ownerInventory;
    }

    public void setClientInventory(Inventory clientInventory) {
        this.clientInventory = clientInventory;
    }

    public Inventory getClientInventory() {
        return this.clientInventory;
    }

    public TransactionEvent.TransactionType getTransactionType() {
        return this.transactionType;
    }

    public boolean isCancelled() {
        return this.transactionOutcome != TransactionOutcome.TRANSACTION_SUCCESFUL;
    }

    public TransactionOutcome getTransactionOutcome() {
        return this.transactionOutcome;
    }

    public void setCancelled(TransactionOutcome reason) {
        this.transactionOutcome = reason;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactionOutcome {
        SHOP_DOES_NOT_BUY_THIS_ITEM,
        SHOP_DOES_NOT_SELL_THIS_ITEM,
        CLIENT_DOES_NOT_HAVE_PERMISSION,
        CLIENT_DOES_NOT_HAVE_ENOUGH_MONEY,
        SHOP_DOES_NOT_HAVE_ENOUGH_MONEY,
        CLIENT_DEPOSIT_FAILED,
        SHOP_DEPOSIT_FAILED,
        NOT_ENOUGH_SPACE_IN_CHEST,
        NOT_ENOUGH_SPACE_IN_INVENTORY,
        NOT_ENOUGH_STOCK_IN_CHEST,
        NOT_ENOUGH_STOCK_IN_INVENTORY,
        INVALID_SHOP,
        SPAM_CLICKING_PROTECTION,
        CREATIVE_MODE_PROTECTION,
        SHOP_IS_RESTRICTED,
        OTHER,
        TRANSACTION_SUCCESFUL;

    }
}

