/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block.Break;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.Acrobot.ChestShop.Utils.uName;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.PistonBaseMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignBreak
implements Listener {
    private static final BlockFace[] SIGN_CONNECTION_FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP};

    @EventHandler(ignoreCancelled=true)
    public static void onSignBreak(BlockBreakEvent event) {
        if (!SignBreak.canBlockBeBroken(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : SignBreak.getExtendBlocks(event)) {
            if (SignBreak.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!SignBreak.canBlockBeBroken(SignBreak.getRetractBlock(event), null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onExplosion(EntityExplodeEvent event) {
        if (event.blockList() == null || !Properties.USE_BUILT_IN_PROTECTION) {
            return;
        }
        for (Block block : event.blockList()) {
            if (SignBreak.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    public static boolean canBlockBeBroken(Block block, Player breaker) {
        List<Sign> attachedSigns = SignBreak.getAttachedSigns(block);
        LinkedList<Sign> brokenBlocks = new LinkedList<Sign>();
        boolean canBeBroken = true;
        for (Sign sign : attachedSigns) {
            sign.update();
            if (!canBeBroken || !ChestShopSign.isValid(sign)) continue;
            if (Properties.TURN_OFF_SIGN_PROTECTION || SignBreak.canDestroyShop(breaker, sign.getLine(0))) {
                brokenBlocks.add(sign);
                continue;
            }
            canBeBroken = false;
        }
        if (!canBeBroken) {
            return false;
        }
        for (Sign sign : brokenBlocks) {
            SignBreak.sendShopDestroyedEvent(sign, breaker);
        }
        return true;
    }

    private static boolean canDestroyShop(Player player, String name) {
        return player != null && (SignBreak.hasShopBreakingPermission(player) || SignBreak.canUseName(player, name));
    }

    private static boolean canUseName(Player player, String name) {
        return uName.canUseName(player, name);
    }

    private static boolean hasShopBreakingPermission(Player player) {
        return Permission.has(player, Permission.ADMIN) || Permission.has(player, Permission.MOD);
    }

    private static void sendShopDestroyedEvent(Sign sign, Player player) {
        Chest connectedChest = null;
        if (!ChestShopSign.isAdminShop(sign)) {
            connectedChest = uBlock.findConnectedChest(sign.getBlock());
        }
        ShopDestroyedEvent event = new ShopDestroyedEvent(player, sign, connectedChest);
        ChestShop.callEvent(event);
    }

    private static List<Sign> getAttachedSigns(Block block) {
        if (block == null) {
            return Lists.newArrayList();
        }
        if (BlockUtil.isSign(block)) {
            return Arrays.asList((Sign)block.getState());
        }
        LinkedList<Sign> attachedSigns = new LinkedList<Sign>();
        for (BlockFace face : SIGN_CONNECTION_FACES) {
            Sign sign;
            Block relative = block.getRelative(face);
            if (!BlockUtil.isSign(relative) || !BlockUtil.getAttachedFace(sign = (Sign)relative.getState()).equals(block)) continue;
            attachedSigns.add(sign);
        }
        return attachedSigns;
    }

    private static Block getRetractBlock(BlockPistonRetractEvent event) {
        Block block = SignBreak.getRetractLocationBlock(event);
        return block != null && !BlockUtil.isSign(block) ? block : null;
    }

    private static BlockFace getPistonDirection(Block block) {
        return block.getState().getData() instanceof PistonBaseMaterial ? ((Directional)block.getState().getData()).getFacing() : null;
    }

    private static Block getRetractLocationBlock(BlockPistonRetractEvent event) {
        BlockFace pistonDirection = SignBreak.getPistonDirection(event.getBlock());
        return pistonDirection != null ? event.getBlock().getRelative(pistonDirection, 2).getLocation().getBlock() : null;
    }

    private static List<Block> getExtendBlocks(BlockPistonExtendEvent event) {
        Block block;
        Material blockType;
        BlockFace pistonDirection = SignBreak.getPistonDirection(event.getBlock());
        if (pistonDirection == null) {
            return new ArrayList<Block>();
        }
        Block piston = event.getBlock();
        ArrayList<Block> pushedBlocks = new ArrayList<Block>();
        for (int currentBlock = 1; currentBlock < event.getLength() + 1 && (blockType = (block = piston.getRelative(pistonDirection, currentBlock)).getType()) != Material.AIR; ++currentBlock) {
            pushedBlocks.add(block);
        }
        return pushedBlocks;
    }
}

