/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PostTransaction;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.DB.Queue;
import com.Acrobot.ChestShop.DB.Transaction;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class TransactionLogger
implements Listener {
    private static final String BUY_MESSAGE = "%1$s bought %2$s for %3$.2f from %4$s at %5$s";
    private static final String SELL_MESSAGE = "%1$s sold %2$s for %3$.2f to %4$s at %5$s";

    @EventHandler
    public static void onTransaction(TransactionEvent event) {
        String template = event.getTransactionType() == TransactionEvent.TransactionType.BUY ? BUY_MESSAGE : SELL_MESSAGE;
        StringBuilder items = new StringBuilder(50);
        for (ItemStack item : event.getStock()) {
            items.append(item.getAmount()).append(' ').append(MaterialUtil.getSignName(item));
        }
        String message = String.format(template, event.getClient().getName(), items.toString(), event.getPrice(), event.getOwner().getName(), TransactionLogger.locationToString(event.getSign().getLocation()));
        ChestShop.getBukkitLogger().info(message);
    }

    @EventHandler
    public static void onTransactionLogToDB(TransactionEvent event) {
        if (!Properties.LOG_TO_DATABASE && !Properties.GENERATE_STATISTICS_PAGE) {
            return;
        }
        double pricePerStack = event.getPrice() / (double)event.getStock().length;
        for (ItemStack item : event.getStock()) {
            Transaction transaction = new Transaction();
            transaction.setAmount(item.getAmount());
            transaction.setItemID(item.getTypeId());
            transaction.setItemDurability(item.getDurability());
            transaction.setPrice((float)pricePerStack);
            transaction.setShopOwner(event.getOwner().getName());
            transaction.setShopUser(event.getClient().getName());
            transaction.setSec(System.currentTimeMillis() / 1000L);
            transaction.setBuy(event.getTransactionType() == TransactionEvent.TransactionType.BUY);
            Queue.addToQueue(transaction);
        }
    }

    private static String locationToString(Location loc) {
        return '[' + loc.getWorld().getName() + "] " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
    }
}

