/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PostTransaction;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Utils.uName;
import com.google.common.base.Joiner;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class TransactionMessageSender
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public static void onTransaction(TransactionEvent event) {
        if (event.getTransactionType() == TransactionEvent.TransactionType.BUY) {
            TransactionMessageSender.sendBuyMessage(event);
        } else {
            TransactionMessageSender.sendSellMessage(event);
        }
    }

    protected static void sendBuyMessage(TransactionEvent event) {
        String message;
        String itemName = TransactionMessageSender.parseItemInformation(event.getStock());
        String owner = event.getOwner().getName();
        Player player = event.getClient();
        String price = Economy.formatBalance(event.getPrice());
        if (Properties.SHOW_TRANSACTION_INFORMATION_CLIENT) {
            message = TransactionMessageSender.formatMessage(Messages.YOU_BOUGHT_FROM_SHOP, itemName, price);
            message = message.replace("%owner", owner);
            player.sendMessage(message);
        }
        if (Properties.SHOW_TRANSACTION_INFORMATION_OWNER) {
            message = TransactionMessageSender.formatMessage(Messages.SOMEBODY_BOUGHT_FROM_YOUR_SHOP, itemName, price);
            message = message.replace("%buyer", player.getName());
            TransactionMessageSender.sendMessageToOwner(message, event);
        }
    }

    protected static void sendSellMessage(TransactionEvent event) {
        String message;
        String itemName = TransactionMessageSender.parseItemInformation(event.getStock());
        String owner = event.getOwner().getName();
        Player player = event.getClient();
        String price = Economy.formatBalance(event.getPrice());
        if (Properties.SHOW_TRANSACTION_INFORMATION_CLIENT) {
            message = TransactionMessageSender.formatMessage(Messages.YOU_SOLD_TO_SHOP, itemName, price);
            message = message.replace("%buyer", owner);
            player.sendMessage(message);
        }
        if (Properties.SHOW_TRANSACTION_INFORMATION_OWNER) {
            message = TransactionMessageSender.formatMessage(Messages.SOMEBODY_SOLD_TO_YOUR_SHOP, itemName, price);
            message = message.replace("%seller", player.getName());
            TransactionMessageSender.sendMessageToOwner(message, event);
        }
    }

    private static String parseItemInformation(ItemStack[] items) {
        ItemStack[] stock = InventoryUtil.mergeSimilarStacks(items);
        StringBuilder message = new StringBuilder(15);
        Joiner joiner = Joiner.on((char)' ');
        for (ItemStack item : stock) {
            joiner.appendTo(message, (Object)item.getAmount(), (Object)MaterialUtil.getName(item), new Object[0]);
        }
        return message.toString();
    }

    private static void sendMessageToOwner(String message, TransactionEvent event) {
        String owner = event.getOwner().getName();
        Player player = Bukkit.getPlayerExact((String)(owner = uName.getName(owner)));
        if (player != null) {
            player.sendMessage(message);
        }
    }

    private static String formatMessage(String message, String item, String price) {
        return Messages.prefix(message).replace("%item", item).replace("%price", price);
    }
}

