/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import java.util.regex.Matcher;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemChecker
implements Listener {
    private static final short MAXIMUM_SIGN_LETTERS = 15;

    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String data;
        String itemCode = event.getSignLine((byte)3);
        ItemStack item = MaterialUtil.getItem(itemCode);
        if (item == null) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_ITEM);
            return;
        }
        if (MaterialUtil.Odd.getFromString(itemCode) != null) {
            return;
        }
        String metadata = ItemChecker.getMetadata(itemCode);
        String longName = MaterialUtil.getName(item);
        if (longName.length() <= 15 - metadata.length() && ItemChecker.isSameItem(longName + metadata, item)) {
            String itemName = StringUtil.capitalizeFirstLetter(longName);
            event.setSignLine((byte)3, itemName + metadata);
            return;
        }
        String code = MaterialUtil.getName(item, false);
        String[] parts = itemCode.split("(?=:|-|#)", 2);
        String string = data = parts.length > 1 ? parts[1] : "";
        if (!data.isEmpty() && code.length() > 15 - data.length()) {
            code = code.substring(0, 15 - data.length());
        }
        if (!ItemChecker.isSameItem(code + data, item)) {
            code = String.valueOf(item.getTypeId());
        }
        code = StringUtil.capitalizeFirstLetter(code);
        event.setSignLine((byte)3, code + data);
    }

    private static boolean isSameItem(String newCode, ItemStack item) {
        ItemStack newItem = MaterialUtil.getItem(newCode);
        return newItem != null && MaterialUtil.equals(newItem, item);
    }

    private static String getMetadata(String itemCode) {
        Matcher m = MaterialUtil.METADATA.matcher(itemCode);
        if (!m.find()) {
            return "";
        }
        return m.group();
    }
}

