/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import java.util.LinkedList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PartialTransactionModule
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public static void onPreBuyTransaction(PreTransactionEvent event) {
        String seller;
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.BUY) {
            return;
        }
        Player client = event.getClient();
        String clientName = client.getName();
        ItemStack[] stock = event.getStock();
        double price = event.getPrice();
        double pricePerItem = event.getPrice() / (double)InventoryUtil.countItems(stock);
        double walletMoney = Economy.getBalance(clientName);
        if (!Economy.hasEnough(clientName, price)) {
            int amountAffordable = PartialTransactionModule.getAmountOfAffordableItems(walletMoney, pricePerItem);
            if (amountAffordable < 1) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DOES_NOT_HAVE_ENOUGH_MONEY);
                return;
            }
            event.setPrice((double)amountAffordable * pricePerItem);
            event.setStock(PartialTransactionModule.getCountedItemStack(stock, amountAffordable));
        }
        if (!Economy.canHold(seller = event.getOwner().getName(), price)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.SHOP_DEPOSIT_FAILED);
            return;
        }
        stock = event.getStock();
        if (!InventoryUtil.hasItems(stock, event.getOwnerInventory())) {
            ItemStack[] itemsHad = PartialTransactionModule.getItems(stock, event.getOwnerInventory());
            int posessedItemCount = InventoryUtil.countItems(itemsHad);
            if (posessedItemCount <= 0) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_STOCK_IN_CHEST);
                return;
            }
            event.setPrice(pricePerItem * (double)posessedItemCount);
            event.setStock(itemsHad);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public static void onPreSellTransaction(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.SELL) {
            return;
        }
        String player = event.getClient().getName();
        String ownerName = event.getOwner().getName();
        ItemStack[] stock = event.getStock();
        double price = event.getPrice();
        double pricePerItem = event.getPrice() / (double)InventoryUtil.countItems(stock);
        double walletMoney = Economy.getBalance(ownerName);
        if (Economy.isOwnerEconomicallyActive(event.getOwnerInventory()) && !Economy.hasEnough(ownerName, price)) {
            int amountAffordable = PartialTransactionModule.getAmountOfAffordableItems(walletMoney, pricePerItem);
            if (amountAffordable < 1) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.SHOP_DOES_NOT_HAVE_ENOUGH_MONEY);
                return;
            }
            event.setPrice((double)amountAffordable * pricePerItem);
            event.setStock(PartialTransactionModule.getCountedItemStack(stock, amountAffordable));
        }
        stock = event.getStock();
        if (!Economy.canHold(player, price)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DEPOSIT_FAILED);
            return;
        }
        if (!InventoryUtil.hasItems(stock, event.getClientInventory())) {
            ItemStack[] itemsHad = PartialTransactionModule.getItems(stock, event.getClientInventory());
            int posessedItemCount = InventoryUtil.countItems(itemsHad);
            if (posessedItemCount <= 0) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_STOCK_IN_INVENTORY);
                return;
            }
            event.setPrice(pricePerItem * (double)posessedItemCount);
            event.setStock(itemsHad);
        }
    }

    private static int getAmountOfAffordableItems(double walletMoney, double pricePerItem) {
        return (int)Math.floor(walletMoney / pricePerItem);
    }

    private static ItemStack[] getItems(ItemStack[] stock, Inventory inventory) {
        ItemStack[] neededItems;
        LinkedList<ItemStack> toReturn = new LinkedList<ItemStack>();
        for (ItemStack item : neededItems = InventoryUtil.mergeSimilarStacks(stock)) {
            int amount = InventoryUtil.getAmount(item, inventory);
            ItemStack clone = item.clone();
            clone.setAmount(amount > item.getAmount() ? item.getAmount() : amount);
            toReturn.add(clone);
        }
        return toReturn.toArray(new ItemStack[toReturn.size()]);
    }

    private static ItemStack[] getCountedItemStack(ItemStack[] stock, int numberOfItems) {
        int left = numberOfItems;
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (ItemStack stack : stock) {
            ItemStack toAdd;
            int count = stack.getAmount();
            if (left > count) {
                toAdd = stack;
                left -= count;
            } else {
                ItemStack clone = stack.clone();
                clone.setAmount(left);
                toAdd = clone;
                left = 0;
            }
            boolean added = false;
            for (ItemStack iStack : stacks) {
                if (!MaterialUtil.equals(toAdd, iStack)) continue;
                iStack.setAmount(iStack.getAmount() + toAdd.getAmount());
                added = true;
                break;
            }
            if (!added) {
                stacks.add(toAdd);
            }
            if (left <= 0) break;
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }
}

