/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Metadata;

import com.Acrobot.Breeze.Database.Database;
import com.Acrobot.Breeze.Database.Row;
import com.Acrobot.Breeze.Database.Table;
import com.Acrobot.Breeze.Utils.Encoding.Base62;
import com.Acrobot.Breeze.Utils.Encoding.Base64;
import com.Acrobot.ChestShop.ChestShop;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class ItemDatabase {
    private Yaml yaml;
    private Table table;

    public ItemDatabase() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ChestShop.getBukkitLogger().severe("You haven't got any SQLite JDBC installed!");
        }
        Database database = new Database("jdbc:sqlite:" + ChestShop.loadFile("items.db").getAbsolutePath());
        this.yaml = new Yaml((BaseConstructor)new YamlConstructor(), (Representer)new YamlRepresenter(), new DumperOptions());
        try {
            Statement statement = database.getConnection().createStatement();
            statement.executeUpdate("PRAGMA user_version = 1");
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.table = database.getTable("items");
            this.table.create("id INTEGER PRIMARY KEY, code VARCHAR UNIQUE ON CONFLICT IGNORE");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getItemCode(ItemStack item) {
        try {
            String code = Base64.encodeObject((Serializable)((Object)this.yaml.dump((Object)item)));
            this.table.insertRow("null, '" + code + '\'');
            int id = Integer.parseInt(this.table.getRow("code='" + code + '\'').get("id"));
            return Base62.encode(id);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack getFromCode(String code) {
        try {
            Row row = this.table.getRow("id='" + Base62.decode(code) + '\'');
            if (row.getSize() == 0) {
                return null;
            }
            String serialized = row.get("code");
            return (ItemStack)this.yaml.load((String)Base64.decodeToObject(serialized));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

