/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;

public class uBlock {
    public static final BlockFace[] CHEST_EXTENSION_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    public static final BlockFace[] SHOP_FACES = new BlockFace[]{BlockFace.SELF, BlockFace.DOWN, BlockFace.UP, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    public static final BlockFace[] NEIGHBOR_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};

    public static Sign getConnectedSign(Chest chest) {
        Sign sign = uBlock.findAnyNearbyShopSign(chest.getBlock());
        if (sign == null && uBlock.getNeighbor(chest) != null) {
            sign = uBlock.findAnyNearbyShopSign(uBlock.getNeighbor(chest).getBlock());
        }
        return sign;
    }

    private static Chest getNeighbor(Chest chest) {
        Block chestBlock = chest.getBlock();
        for (BlockFace chestFace : NEIGHBOR_FACES) {
            Block relative = chestBlock.getRelative(chestFace);
            if (!BlockUtil.isChest(relative)) continue;
            return (Chest)relative.getState();
        }
        return null;
    }

    public static Chest findConnectedChest(Sign sign) {
        Block block = sign.getBlock();
        return uBlock.findConnectedChest(block);
    }

    public static Chest findConnectedChest(Block block) {
        for (BlockFace bf : SHOP_FACES) {
            Block faceBlock = block.getRelative(bf);
            if (!BlockUtil.isChest(faceBlock)) continue;
            return (Chest)faceBlock.getState();
        }
        return null;
    }

    public static Sign findValidShopSign(Block block, String originalName) {
        Sign ownerShopSign = null;
        for (BlockFace bf : SHOP_FACES) {
            Sign sign;
            Block faceBlock = block.getRelative(bf);
            if (!BlockUtil.isSign(faceBlock) || !ChestShopSign.isValid(sign = (Sign)faceBlock.getState()) || !uBlock.signIsAttachedToBlock(sign, block)) continue;
            if (!sign.getLine(0).equals(originalName)) {
                return sign;
            }
            if (ownerShopSign != null) continue;
            ownerShopSign = sign;
        }
        return ownerShopSign;
    }

    public static Sign findAnyNearbyShopSign(Block block) {
        for (BlockFace bf : SHOP_FACES) {
            Sign sign;
            Block faceBlock = block.getRelative(bf);
            if (!BlockUtil.isSign(faceBlock) || !ChestShopSign.isValid(sign = (Sign)faceBlock.getState())) continue;
            return sign;
        }
        return null;
    }

    public static Chest findNeighbor(Block block) {
        for (BlockFace blockFace : CHEST_EXTENSION_FACES) {
            Block neighborBlock = block.getRelative(blockFace);
            if (neighborBlock.getType() != block.getType()) continue;
            return (Chest)neighborBlock.getState();
        }
        return null;
    }

    private static boolean signIsAttachedToBlock(Sign sign, Block block) {
        return sign.getBlock().equals(block) || BlockUtil.getAttachedFace(sign).equals(block);
    }
}

